float4x4 matWorldViewProjection;
float4x4 matWorldView;

float3  LightPosition = {0.f, 100.f, 0.f};
float3  CameraVector = {1.f, 1.f, 1.f};
texture tex0;

samplerCUBE diffuse = 
sampler_state
{
	texture = (tex0);
	MipFilter = Linear; MagFilter = Linear; MinFilter = Linear;
	AddressU = Wrap; AddressV = Wrap;
};


void vs_obj(in float4 ipos : POSITION,
			in float2 itex : TEXCOORD0,
			in float3 normal : NORMAL,
			out float4 opos : POSITION,
			out float2 otex : TEXCOORD0,
			out float3 onormal : TEXCOORD1)
{
	opos = mul(ipos, matWorldViewProjection);
	otex = itex;
	onormal = (mul(normal, matWorldView));
	
	onormal.z -= 1.f;
	//onormal.y += 1.f;//onormal.y-1.f;
};


float4 ps_obj(in float2 tex : TEXCOORD0,
			  in float3 normal : TEXCOORD1) : COLOR0
{
	float  hey = dot(CameraVector, normal);
	float4 hdr = pow(texCUBE(diffuse, normal), 1.2f);
	
	return saturate(hdr);
	return hey;//
	return float4(normal, 1.f);
};

float4 ps_objwhite(in float2 tex : TEXCOORD0,
			  in float3 normal : TEXCOORD1) : COLOR0
{
	return float4(1.f, 1.f, 1.f, 1.f);
};

technique obj
{
	pass p0
	{
		VertexShader = compile vs_2_0 vs_obj();
		PixelShader  = compile ps_2_0 ps_obj();
	}
	
	pass White
	{
		VertexShader = compile vs_2_0 vs_obj();
		PixelShader  = compile ps_2_0 ps_objwhite();
	}
}