float4x4 matProjection;
int thischar; 

float2 fsize = {128.f, 128.f}; //in pixels
float2 offset = {.5f/1024.f, .5f/640.f}; //sampling
float alpha = 1.f;

texture tex1;
sampler2D alphab = 
sampler_state
{
	texture = (tex1);
	AddressU = Clamp; AddressV = Clamp;
	MipFilter = Linear; MagFilter = Linear; MinFilter = Linear;
};

void vs_typer(in float4 ipos : POSITION,
			  in float2 itex : TEXCOORD0,
			  out float4 opos : POSITION,
			  out float2 otex : TEXCOORD0)
{
	opos = mul(ipos, matProjection);
	otex.x = itex.x;
	otex.y = 1.f-itex.y;
	
	//makeout the row/col of the char
	float row = floor(thischar/8.f);
	float col = thischar-(row*8.f);
	
	//convert to texcoords
	otex.x = col*(fsize.x/1024.f) + otex.x*(fsize.x/1024.f);
	otex.y = row*(fsize.y/640.f)  + otex.y*(fsize.y/640.f);
};

float4 ps_typer(in float2 tex : TEXCOORD0) : COLOR0
{
//	return float4(tex.x*1.f, tex.y*0.f, 0.f, 0.f);
	float4 basic = tex2D(alphab, tex+offset);
	basic.a*=alpha;
	return basic; 
}

float4 ps_typercolor(in float2 tex : TEXCOORD0) : COLOR0
{
//	return float4(tex.x*1.f, tex.y*0.f, 0.f, 0.f);
	float4 basic = tex2D(alphab, tex+offset);
	basic.xyz*=alpha;
	return basic; 
}

technique typer
{
	pass standard
	{
		VertexShader = compile vs_2_0 vs_typer();
		PixelShader  = compile ps_2_0 ps_typer();
	}
	
	pass colorbasedalpha
	{
		VertexShader = compile vs_2_0 vs_typer();
		PixelShader  = compile ps_2_0 ps_typercolor();
	}
	
}