float4x4 matProjection;

bool flip = false; 
texture tex1;
sampler2D rendertexture =
sampler_state
{
	texture = (tex1);
	MinFilter = Linear; 
	MagFilter = Linear;
	MipFilter = Linear;
	AddressU = Clamp;
	AddressV = Clamp; 
};

void vs_screen(in float4 ipos : POSITION,
			   in float2 itex : TEXCOORD0,
			   out float4 opos : POSITION,
			   out float2 otex : TEXCOORD0)
{
	opos = mul(ipos, matProjection);
	otex = itex;
	
	if(!flip)
		otex.y = 1.f-otex.y;
}

float4 ps_screen(in float2 tex : TEXCOORD0) : COLOR0
{
	return tex2D(rendertexture, tex); 
}

technique screen
{
	pass base
	{
		VertexShader = compile vs_2_0 vs_screen();
		PixelShader  = compile ps_2_0 ps_screen(); 
	}
}
