float4x4 matWorldViewProjection;
float4x4 matWorldView;
float4x4 matWorld;
float4x4 matLightViewProjection;

float FogEnd = 400.f;
float FogStart = 0.f;

float3 CameraPosition = {100.f, 1.f, 1.f};

texture tex0;

sampler2D lightmap =
sampler_state
{
	texture = (tex0);
	AddressU = Clamp;
	AddressV = Clamp; 
	MipFilter = Point;
	MagFilter = Point;
	MinFilter = Linear; 
};

void vs_floor(in float4 ipos : POSITION,
			  in float3 inorm : NORMAL,
			  in float2 itex : TEXCOORD0,
			  out float4 opos : POSITION,
			  out float3 onorm : TEXCOORD0,
			  out float2 otex : TEXCOORD1,
			  out float4 lightpos : TEXCOORD2,
			  out float3 lightvec : TEXCOORD3,
			  out float fog : TEXCOORD4)
{
	opos = mul(ipos, matWorldViewProjection);
	onorm = normalize(mul(inorm, matWorld)); 
	otex = itex; 
	lightpos = mul(ipos, matLightViewProjection);
	lightvec = normalize(CameraPosition - mul(float4(ipos.xyz, 1.f), matWorld));
	fog =  1.f-clamp( (length(CameraPosition-(mul(float4(ipos.xyz, 1.f), matWorld)))-FogStart)/(FogEnd-FogStart) , 0.f, 1.f);

};

float4 ps_floor(in float3 normal  : TEXCOORD0,
				in float2 tex  : TEXCOORD1,
				in float4 lightpos : TEXCOORD2,
				in float3 lightvec : TEXCOORD3,
				in float fog : TEXCOORD4) : COLOR0
{
	float2 spot = .5f*lightpos.xy/lightpos.w + float2(.5f, .5f);
		spot.y = 1.f - spot.y;
		
	float ndotl = dot(normal, lightvec);
	float4 shadow =  tex2D(lightmap, spot)*.5f;
	
	
	return float4(1.f, 1.f, 1.f, 1.f)*ndotl*(1.f-shadow.r)*fog;
	
	return float4(1.f, 0.f, 0.f, 1.f);
}

technique pigfloor
{
	pass base 
	{
		VertexShader = compile vs_2_0 vs_floor();
		PixelShader  = compile ps_2_0 ps_floor();
	}
}