float4x4 matWorldViewProjection;
float4x4 matWorldView;
float4x4 matWorld; 

float3 CameraPosition = {10.f , 10.f, 100.f};
float4 DiffuseColor = {1.f, 0.f, 0.f, 0.f};

float fog = 1.f;

texture tex0;
sampler2D base = 
sampler_state
{
	texture = (tex0);
	AddressU = Wrap;
	AddressV = Wrap;
	MipFilter = Linear; MagFilter = Linear; MinFilter = Linear; 
};

void vs_phong(in float4 ipos : POSITION,
			  in float3 norm : NORMAL,
			  out float4 opos : POSITION,
			  out float3 onorm : TEXCOORD0,
			  out float3 lightvec : TEXCOORD1)
{
	opos = mul(ipos, matWorldViewProjection);
	onorm = normalize(mul(norm, matWorld));
	lightvec = normalize( CameraPosition - mul(ipos, matWorld));
};

void vs_tcolor(in float4 ipos : POSITION,
			  in float3 norm : NORMAL,
			  in float2 itex : TEXCOORD0,
			  out float4 opos : POSITION,
			  out float3 onorm : TEXCOORD0,
			  out float3 lightvec : TEXCOORD1,
			  out float2 otex : TEXCOORD2)
{
	otex = itex; 
	opos = mul(ipos, matWorldViewProjection);
	onorm = normalize(mul(norm, matWorld));
	lightvec = normalize( CameraPosition - mul(ipos, matWorld));
};

float4 ps_phong(in float3 normal : TEXCOORD0,
				in float3 lightvec : TEXCOORD1) : COLOR0
{
	float ndotl = dot(normal, lightvec);
	return DiffuseColor *ndotl*fog;
};


float4 ps_tex(in float3 normal : TEXCOORD0,
				in float3 lightvec : TEXCOORD1,
				in float2 tex : TEXCOORD2) : COLOR0
{
	float ndotl = dot(normal, lightvec);
	return tex2D(base, tex)*ndotl*fog;
};

technique phong
{
	pass base
	{
		VertexShader = compile vs_2_0 vs_phong();
		PixelShader  = compile ps_2_0 ps_phong();
	}
	
	pass tex
	{
		VertexShader = compile vs_2_0 vs_tcolor();
		PixelShader  = compile ps_2_0 ps_tex();
	}
	
}