float4x4 matWorldViewProjection;
float4x4 matWorldView;
float4x4 matWorld; 

float3 Light2 = {0.f, 0.f, 0.f};
float3 CameraPosition = {1.f , 100.f, 1.f};
float3 LightPosition = {1.f, 100.f, 1.f};
float FogEnd = 200.f;
float FogStart = 0.f;

float time; 

//////////////////////pass1
float4x4 matLightViewProjection;
texture tex0;
sampler2D base = 
sampler_state
{
	texture = (tex0);
	AddressU = Clamp;
	AddressV = Clamp;
	MipFilter = Linear; MagFilter = Linear; MinFilter = Linear; 
};

texture tex1;
sampler2D grid = 
sampler_state
{
	texture = (tex1);
	AddressU = Wrap;
	AddressV = Wrap;
	MipFilter = Linear; MagFilter = Linear; MinFilter = Linear; 
};


void vs_phong(in float4 ipos : POSITION,
			  in float3 norm : NORMAL,
			  out float4 opos : POSITION,
			  out float3 onorm : TEXCOORD0,
			  out float3 lightvec : TEXCOORD1,
			  out float  fog : TEXCOORD2,
			  out float3 light2 : TEXCOORD3)
{
	opos = mul(ipos, matWorldViewProjection);
	onorm = normalize(mul(norm, matWorldView));
	fog = 1.f-clamp( (length(CameraPosition-mul(ipos, matWorld))-FogStart)/(FogEnd-FogStart) , 0.f, 1.f);
	lightvec = normalize( CameraPosition - mul(float4(ipos.xyz, 1.f), matWorld));
	light2 = normalize ( Light2 - mul(ipos, matWorld));
};

float4 ps_phong(in float3 normal : TEXCOORD0,
				in float3 lightvec : TEXCOORD1,
				in float  fog : TEXCOORD2) : COLOR0
{
//	return float4(1.f, 1.f, 1.f, 1.f)*fog;
//	return float4(normal.xyz, 1.f)*fog;
	float ndotl = dot(normal, lightvec);	
	return float4(1.f, 1.f, 1.f, 1.f)*fog*ndotl;
};

float4 ps_phong2(in float3 normal : TEXCOORD0,
				in float3 lightvec : TEXCOORD1,
				in float  fog : TEXCOORD2,
				in float3 light2 : TEXCOORD3) : COLOR0
{
	
	float ndotl = dot(abs(normal), lightvec);
	float ndotl2 = dot(normal, light2);	
	return float4(1.f, 1.f, 1.f, 1.f)*fog*(ndotl);//+ndotl2);
};


void vs_proj(in float4 ipos : POSITION,
			  in float3 norm : NORMAL,
			  in float2 itex : TEXCOORD0,
			  out float4 opos : POSITION,
			  out float3 onorm : TEXCOORD0,
			  out float3 lightvec : TEXCOORD1,
			  out float  fog : TEXCOORD2,
			  out float4 lightpos : TEXCOORD3,
			  out float2 otex : TEXCOORD4)
{

	otex = 10.f*itex;
	otex.y += 5.f*time;  
	opos = mul(ipos, matWorldViewProjection);
	onorm = normalize(mul(norm, matWorld));
//	fog = 1.f-clamp( (length(CameraPosition-mul(ipos, matWorld))-FogStart)/(FogEnd-FogStart) , 0.f, 1.f);
//	FogEnd = 200.f;
	fog =  1.f-clamp( (length(CameraPosition-(mul(float4(ipos.xyz, 1.f), matWorld)))-FogStart)/(FogEnd-FogStart) , 0.f, 1.f);

	lightvec = normalize( LightPosition - mul(ipos, matWorld));
	lightpos = mul(ipos, matLightViewProjection);
};

float4 ps_proj(in float3 normal : TEXCOORD0,
				in float3 lightvec : TEXCOORD1,
				in float  fog : TEXCOORD2,
				in float4 lightpos : TEXCOORD3,
				in float2 texO : TEXCOORD4) : COLOR0
{

	float2 spot = .5f*lightpos.xy/lightpos.w + float2(.5f, .5f);
	spot.y = 1.f - spot.y;
	
	
	float ndotl = dot(normal, lightvec);
	
	float4 tex = tex2D(base, spot)*.5f;
	float4 kukhar= (tex2D(grid, texO));
	
	float tex2 = clamp(kukhar.r+.7f, 0.f, 1.2f);// min(1.f, kukhar.r+.7f); 
	
	//return float4(normal.xyz, 1.f);
//	return float4(1.f, 1.f, 1.f, 1.f);
	
	return (float4(1.f, 1.f, 1.f, tex.a)*tex2)*(1.f-tex.r)*fog*ndotl;
//	return float4(1.f, 1.f, 1.f, 1.f)*fog*ndotl;
};


technique phong
{
	pass base
	{
		VertexShader = compile vs_2_0 vs_phong();
		PixelShader  = compile ps_2_0 ps_phong();
	}
	
	pass projection
	{
		VertexShader = compile vs_2_0 vs_proj();
		PixelShader = compile ps_2_0 ps_proj();
	}
	
	pass light2
	{
		VertexShader = compile vs_2_0 vs_phong();
		PixelShader = compile ps_2_0 ps_phong2();
	}
}