float4x4 matView;
float4x4 matViewProjection;

float  alpha1 = 1.f;
float2 ParticleSize = {3.f, 3.f};


float FogEnd = 300.f;
float FogStart = 0.f;
float3 CameraPosition = {1.f, 1.f, 1.f};

float2 fsize = {128.f, 128.f};
float time; 

texture tex0; //diffuse
sampler2D diffuse = 
sampler_state
{
	texture = (tex0);
	MipFilter = Linear; MagFilter = Linear; MinFilter = Linear;
	AddressU = Clamp; AddressV = Clamp;
};

void vs_partikkel(in float3 ipos : POSITION,
				  in float2 itex : TEXCOORD0,
				  out float4 opos : POSITION,
				  out float2 otex : TEXCOORD0,
				  out float2 otex2 : TEXCOORD1,
				  out float  inter : TEXCOORD2,
				  out float  fog : TEXCOORD3)
{
	float realz = floor(ipos.z*.1f);
	inter = (ipos.z*.1f)-realz;
	
	//realz = 4.f;
	float thischar = (int)(20.f+20.f*sin(realz+ipos.x));
	float thischar2 = (int)(20.f+20.f*sin((realz+1.f)+ipos.x));
	

//	fog = 1.f-length(ipos.xy)/40.f;	
	fog = 1.f-clamp( (length(CameraPosition-(ipos))-FogStart)/(FogEnd-FogStart) , 0.f, 1.f);

	//ipos.y = 60.f*sin( (ipos.y/40)*1.2f);
	ipos += float3(matView._11, matView._21, matView._31)*itex.x*ParticleSize.x;
	ipos += float3(matView._12, matView._22, matView._32)*itex.y*ParticleSize.y;
	opos = mul(float4(ipos, 1.f), matViewProjection);

	otex = itex + .5f;
	otex2 = otex;

	//makeout the row/col of the char
	float row = floor(thischar/8.f);
	float col = thischar-(row*8.f);
	
	float row2 = floor(thischar2/8.f);
	float col2 = thischar2-(row2*8.f);
	
	//convert to texcoords
	otex.x = col*(fsize.x/1024.f) + otex.x*(fsize.x/1024.f);
	otex.y = row*(fsize.y/640.f)  + otex.y*(fsize.y/640.f);
	
	otex2.x = col2*(fsize.x/1024.f) + otex2.x*(fsize.x/1024.f);
	otex2.y = row2*(fsize.y/640.f)  + otex2.y*(fsize.y/640.f);
	//fog = 1.f-clamp( (length(CameraPosition-(ipos))-FogStart)/(FogEnd-FogStart) , 0.f, 1.f);
}

void vs_cpartikkel(in float3 ipos : POSITION,
				  in float2 itex : TEXCOORD0,
				  out float4 opos : POSITION,
				  out float2 otex : TEXCOORD0,
				  out float2 otex2 : TEXCOORD1,
				  out float  inter : TEXCOORD2,
				  out float  fog : TEXCOORD3)
{
	float realz = floor(ipos.z*.1f);
	inter = (ipos.z*.1f)-realz;
	
	//realz = 4.f;
	float thischar = (int)(20.f+20.f*sin(realz+ipos.x*.001f));
	float thischar2 = (int)(20.f+20.f*sin((realz+1.f)+ipos.x*.001f));
	

//	fog = 1.f-length(ipos.xy)/40.f;	
	fog = 1.f-clamp( (length(CameraPosition-(ipos))-FogStart)/(FogEnd-FogStart) , 0.f, 1.f);

	//ipos.y = 60.f*sin( (ipos.y/40)*1.2f);
	ipos += float3(matView._11, matView._21, matView._31)*itex.x*ParticleSize.x;
	ipos += float3(matView._12, matView._22, matView._32)*itex.y*ParticleSize.y;
	opos = mul(float4(ipos, 1.f), matViewProjection);

	otex = itex + .5f;
	otex2 = otex;

	//makeout the row/col of the char
	float row = floor(thischar/8.f);
	float col = thischar-(row*8.f);
	
	float row2 = floor(thischar2/8.f);
	float col2 = thischar2-(row2*8.f);
	
	//convert to texcoords
	otex.x = col*(fsize.x/1024.f) + otex.x*(fsize.x/1024.f);
	otex.y = row*(fsize.y/640.f)  + otex.y*(fsize.y/640.f);
	
	otex2.x = col2*(fsize.x/1024.f) + otex2.x*(fsize.x/1024.f);
	otex2.y = row2*(fsize.y/640.f)  + otex2.y*(fsize.y/640.f);
	//fog = 1.f-clamp( (length(CameraPosition-(ipos))-FogStart)/(FogEnd-FogStart) , 0.f, 1.f);
}


void vs_partikkelsize(in float3 ipos : POSITION,
				  in float2 itex : TEXCOORD0,
				  out float4 opos : POSITION,
				  out float2 otex : TEXCOORD0,
				  out float2 otex2 : TEXCOORD1,
				  out float  inter : TEXCOORD2,
				  out float  fog : TEXCOORD3)
{
	float realz = floor(ipos.z*.1f);
	inter = (ipos.z*.1f)-realz;
	
	ParticleSize.x = 4.f + 2.f*sin(length(ipos)*.2f+ time*3.f);

	
	//realz = 4.f;
	float thischar = (int)(20.f+20.f*sin(realz+ipos.x));
	float thischar2 = (int)(20.f+20.f*sin((realz+1.f)+ipos.x));
	

//	fog = 1.f-length(ipos.xy)/40.f;	
	fog = 1.f-clamp( (length(CameraPosition-(ipos))-FogStart)/(FogEnd-FogStart) , 0.f, 1.f);

	//ipos.y = 60.f*sin( (ipos.y/40)*1.2f);
	ipos += float3(matView._11, matView._21, matView._31)*itex.x*ParticleSize.x;
	ipos += float3(matView._12, matView._22, matView._32)*itex.y*ParticleSize.x;
	opos = mul(float4(ipos, 1.f), matViewProjection);

	otex = itex + .5f;
	otex2 = otex;

	//makeout the row/col of the char
	float row = floor(thischar/8.f);
	float col = thischar-(row*8.f);
	
	float row2 = floor(thischar2/8.f);
	float col2 = thischar2-(row2*8.f);
	
	//convert to texcoords
	otex.x = col*(fsize.x/1024.f) + otex.x*(fsize.x/1024.f);
	otex.y = row*(fsize.y/640.f)  + otex.y*(fsize.y/640.f);
	
	otex2.x = col2*(fsize.x/1024.f) + otex2.x*(fsize.x/1024.f);
	otex2.y = row2*(fsize.y/640.f)  + otex2.y*(fsize.y/640.f);
	//fog = 1.f-clamp( (length(CameraPosition-(ipos))-FogStart)/(FogEnd-FogStart) , 0.f, 1.f);
}


float4 ps_partikkel(in float2 tex : TEXCOORD0,
					in float2 tex2: TEXCOORD1,
					in float inter : TEXCOORD2,
					in float fog : TEXCOORD3) : COLOR0
{
	float4 a = tex2D(diffuse, tex);
	float4 b = tex2D(diffuse, tex2);
	float4 p = lerp(a, b, inter);
	float4 ut =  p*alpha1;
	
	clip(p-.1f);
	return ut;
}


float4 ps_partikkelfog(in float2 tex : TEXCOORD0,
					in float2 tex2: TEXCOORD1,
					in float inter : TEXCOORD2,
					in float fog : TEXCOORD3) : COLOR0
{
	float4 a = tex2D(diffuse, tex);
	float4 b = tex2D(diffuse, tex2);
	float4 p = lerp(a, b, inter)*fog;
	float4 ut =  p*alpha1;
	
	clip(p-.1f);
	return ut;
}


float4 ps_rekker(in float2 tex : TEXCOORD0,
					in float2 tex2: TEXCOORD1,
					in float inter : TEXCOORD2,
					in float fog : TEXCOORD3) : COLOR0
{
	float4 a = tex2D(diffuse, tex);
	float4 b = tex2D(diffuse, tex2);
	float4 p = lerp(a, b, inter)*fog;
	float4 ut =  float4(p.rgb, p.r);
	
	//clip(p-.1f);
	return ut;
}


technique Partikkel
{
	pass diffuse
	{
		VertexShader = compile vs_2_0 vs_partikkel();
		PixelShader  = compile ps_2_0 ps_partikkel();
	}
	
	pass diffusefog
	{
		VertexShader = compile vs_2_0 vs_partikkel();
		PixelShader  = compile ps_2_0 ps_partikkelfog();
	}
	
	pass difffusefogsize
	{
		VertexShader = compile vs_2_0 vs_partikkelsize();
		PixelShader  = compile ps_2_0 ps_partikkelfog();
	}
	
	pass diffusefog
	{
		VertexShader = compile vs_2_0 vs_partikkel();
		PixelShader  = compile ps_2_0 ps_rekker();
	}
	
	pass constantfog
	{
		VertexShader = compile vs_2_0 vs_cpartikkel();
		PixelShader  = compile ps_2_0 ps_partikkelfog();
	}
}