float4x4 matWorldViewProjection; 
float4x4 matWorld;

float3 CameraPosition; 

float FogEnd = 400.f;
float FogStart = 0.f;


texture tex0; 
sampler2D mongo = 
sampler_state 
{
	texture = (tex0);
	AddressU = Wrap; 
	AddressV = Wrap; 
	MipFilter = Linear; MinFilter = Linear; MagFilter = Linear; 
};

void vs_line(in float4 ipos : POSITION,
			 in float3 inorm : NORMAL,
			 in float2 itex : TEXCOORD0,
			 out float4 opos : POSITION,
			 out float3 onorm : TEXCOORD0,
			 out float3 lightvec : TEXCOORD1,
			 out float fog : TEXCOORD2,
			 out float2 otex : TEXCOORD3)
{
	opos = mul(ipos, matWorldViewProjection);
	onorm = normalize(mul(inorm, matWorld));
	fog = 1.f-clamp( (length(CameraPosition-(ipos))-FogStart)/(FogEnd-FogStart) , 0.f, 1.f);
	lightvec = normalize( CameraPosition - mul(ipos, matWorld) ); 
	
	otex = itex; 
};


float4 ps_line(in float3 normal : TEXCOORD0,
			   in float3 lightvec : TEXCOORD1,
			   in float fog : TEXCOORD2,
			   in float2 tex : TEXCOORD3) : COLOR0
{
	float ndotl = dot(abs(normal), lightvec);
	float4 pul = 1.f-tex2D(mongo, tex);
	
	return float4(1.f, 1.f, 1.f, 1.f)*ndotl*pul*fog;
};

technique line
{
	pass basj
	{
		VertexShader = compile vs_2_0 vs_line();
		PixelShader  = compile ps_2_0 ps_line();
	}
};