float4x4 matProjection;

float power = 0.f;
float2 texeloffset = {.5f/800.f, .5f/600.f};
float2 offset = {1.f/800.f, 1.f/600.f};
float egdethicness = .125f; 
texture tex1;
texture tex2;

bool flip = false; 

sampler2D base = 
sampler_state 
{
	texture = (tex1);
	AddressU = Wrap;
	AddressV = Wrap;
	MipFilter = Linear; MagFilter = Linear; MinFilter = Linear;
};

sampler2D overlay = 
sampler_state 
{
	texture = (tex2);
	AddressU = Wrap;
	AddressV = Wrap;
	MipFilter = Linear; MagFilter = Linear; MinFilter = Linear;
};

void vs_egde(in float4 ipos : POSITION,
			 in float2 itex : TEXCOORD0,
			 out float4 opos : POSITION,
			 out float2 otex : TEXCOORD0,
			 out float2 lf : TEXCOORD1,
			 out float2 rf : TEXCOORD2)
{
	opos = mul(ipos, matProjection);
	

	otex = itex; 
//

	if(flip)
		otex.y = 1.f-itex.y; 
		
	otex = otex+texeloffset;
	lf.x = otex.x+offset.x; 
	lf.y = otex.y+offset.y;
	rf.x = otex.x-offset.x;
	rf.y = otex.y-offset.y;
	
};

float4 ps_egde(in float2 tex : TEXCOORD0,
			   in float2 lf : TEXCOORD1,
			   in float2 rf : TEXCOORD2) : COLOR0
{
	
	//tex += texeloffset;
	float4 p = tex2D(base, tex);
	float4 s = tex2D(base, float2(lf.x, tex.y))+
			   tex2D(base, float2(rf.x, tex.y))+
			   tex2D(base, float2(tex.x,   rf.y))+
			   tex2D(base, float2(tex.x,  rf.y))+
			   tex2D(base, float2(lf.x, lf.y))+
			   tex2D(base, float2(lf.x, rf.y))+
			   tex2D(base, float2(rf.x, lf.y))+
			   tex2D(base, float2(rf.x, rf.y));
	

	float4 edges = 	(8.f*(p - .120f * s));
	
	float4 result =  lerp(edges, p, power);
	float4 overlay = tex2D(overlay, tex);
	
	return result*overlay;
	return (8.f*(p - .120f * s)); 
	
	   
//	return (p+s)/9.f;		   
	//return tex2D(base, otex);
};

technique edge 
{
	pass standard
	{
		VertexShader = compile vs_2_0 vs_egde();
		PixelShader  = compile ps_2_0 ps_egde();
	}
}