float4x4 matWorldViewProjection;
float4x4 matWorld;
float4x4 matWorldView;
float3 CameraPosition = {1.f, 100.f, 1.f};
textureCUBE tex0;
bool flip = false; 
float shine = .01f; 
samplerCUBE lightmap = 
sampler_state
{
    Texture = (tex0);
    MinFilter = Point;
    MagFilter = Point;
    MipFilter = Point;
};

float FogEnd = 400.f;
float FogStart = 0.f;

void vs_anal(in float4 ipos : POSITION,
			 in float3 inorm : NORMAL,
			 out float4 opos : POSITION,
			 out float3 onorm : TEXCOORD0,
			 out float3 lightvec : TEXCOORD1,
			 out float  fog : TEXCOORD2)
{
	opos = mul(ipos, matWorldViewProjection);
	onorm = normalize(mul(inorm, matWorld));
	
	if(flip)
		lightvec = normalize(CameraPosition-mul(float4(ipos.xyz, 1.f), matWorld));
	else
		lightvec = normalize(mul(float4(ipos.xyz, 1.f), matWorld)-CameraPosition);
		
	fog =  1.f-clamp( (length(CameraPosition-(mul(float4(ipos.xyz, 1.f), matWorld)))-FogStart)/(FogEnd-FogStart) , 0.f, 1.f);
	fog = smoothstep(0.f, 1.f, fog);

};

void vs_analog(in float4 ipos : POSITION,
			 in float3 inorm : NORMAL,
			 out float4 opos : POSITION,
			 out float3 onorm : TEXCOORD0,
			 out float3 lightvec : TEXCOORD1,
			 out float  fog : TEXCOORD2)
{
	opos = mul(ipos, matWorldViewProjection);
	onorm = normalize(mul(inorm, matWorld));
	
//	lightvec = normalize(CameraPosition-mul(float4(ipos.xyz, 1.f), matWorld));
	lightvec = normalize(mul(float4(ipos.xyz, 1.f), matWorld)-CameraPosition);
		
	fog =  1.f-clamp( (length(CameraPosition-(mul(float4(ipos.xyz, 1.f), matWorld)))-FogStart)/(FogEnd-FogStart) , 0.f, 1.f);
	fog = smoothstep(0.f, 1.f, fog);

};


float4 ps_anal(in float3 norm : TEXCOORD0,
			 in float3 lightvec : TEXCOORD1,
			 in float fog : TEXCOORD2) : COLOR0
{

	//return float4(1.f, 0.f, 0.f, 0.f);
	float3 ref = reflect(lightvec, norm);
    float4 env = texCUBE(lightmap, ref);
    float ndotl = dot(norm, lightvec); 
	float3 color = float3(1.f, 1.f, 1.f)*ndotl;	
	color = lerp(color, env.rgb, shine);
	//return float4(lightvec.xyz, 1.f);
//	return float4(ref.xyz, 1.f);	
//	return float4(1.f, 1.f, 1.f, 1.f)*ndotl;	
	return float4(color, 1.f)*fog*(1- abs(norm.z));
}

float4 ps_anal2(in float3 norm : TEXCOORD0,
			 in float3 lightvec : TEXCOORD1,
			 in float fog : TEXCOORD2) : COLOR0
{

	//return float4(1.f, 0.f, 0.f, 0.f);
	float3 ref = reflect(lightvec, norm);
    float4 env = texCUBE(lightmap, ref);
    float ndotl = dot(abs(norm), lightvec); 
	float3 color = float3(1.f, 1.f, 1.f)*ndotl;	
	color = lerp(color, env.rgb, shine);
	//return float4(lightvec.xyz, 1.f);
//	return float4(ref.xyz, 1.f);	
//	return float4(1.f, 1.f, 1.f, 1.f)*ndotl;	
	return float4(color, 1.f)*fog;
}
technique anal
{
	pass bajs
	{
		VertexShader = compile vs_2_0 vs_anal();
		PixelShader  = compile ps_2_0 ps_anal();
	}
	
	pass ikkefresnel
	{
		VertexShader = compile vs_2_0 vs_anal();
		PixelShader  = compile ps_2_0 ps_anal2();
	}
}

