#include "sharedfx.h"

texture tMirrorTexture;
sampler sMirrorSampler = 
sampler_state
{
    Texture = <tMirrorTexture>;
    MipFilter = LINEAR;
    MinFilter = LINEAR;
    MagFilter = LINEAR;
    AddressU = CLAMP;
    AddressV = CLAMP;
};

void WaterVS(			float4 inPosition : POSITION,
						float2 inUV : TEXCOORD0,
						out float4 outPosition : POSITION,
						out float4 outProjection : TEXCOORD0,
						out float4 outShadowPosition : TEXCOORD1,
						out float4 outShadowJitterPosition : TEXCOORD2
)
{
	float4 worldPosition = mul(inPosition, mWorld);
	outPosition = mul(worldPosition, mViewProj);
	outProjection = mul(worldPosition, mViewProjBias);
	outShadowPosition = mul(worldPosition, mShadowViewProjBias);
	outShadowJitterPosition = mul(worldPosition, mViewProjBias);
}

float4 WaterPS( float4 inProjection : TEXCOORD0,
				float4 inShadowPosition : TEXCOORD1,
				float4 inShadowJitterPosition : TEXCOORD2
 ) : COLOR
{
	float4 cMirror=tex2Dproj(sMirrorSampler, inProjection)*float4(0.7f, 0.7f, 0.9f, 1.0f);
	float fShadow=CalculateShadow(inShadowPosition, inShadowJitterPosition);
	return cMirror*(fShadow*0.5f+0.5f);
}

technique Water
{
    pass P0
    {          
        VertexShader = compile vs_2_0 WaterVS();
        PixelShader  = compile ps_2_0 WaterPS();
		ZEnable = TRUE;
		ZWriteEnable = TRUE;
		ZFunc = LESSEQUAL;
		AlphaBlendEnable = FALSE;
		AlphaTestEnable = FALSE;
    }
}
