shared float4x4 World          : WORLD          < string SasBindAddress = "Sas.Skeleton.MeshToJointToWorld[0]"; >;
shared float4x4 View           : VIEW           < string SasBindAddress = "Sas.Camera.WorldToView"; >;
shared float4x4 Projection     : PROJECTION     < string SasBindAddress = "Sas.Camera.Projection"; >;
shared float3   CameraPosition : CAMERAPOSITION < string SasBindAddress = "Sas.Camera.Position"; >;
shared float4   Time           : TIME           < string SasBindAddress = "Sas.Time.Now"; >;
shared float3   LightDir       : DIRECTION      < string SasBindAddress = "Sas.DirectionalLight[0].Direction"; >;

//===========================================================================
float2 MapToTexCoord (float2 coord) {
    return (float2(coord.x, -coord.y) + 1) * 0.5f;
}

//===========================================================================
void VertexShader1 (
    float3 position : POSITION,
    out float4 oPos : POSITION
) {
    oPos = mul(mul(mul(float4(position, 1), World), View), Projection);
    oPos+=0.5*sin(Time+position.x*8+position.y*12);
    oPos.r*=0.35;
    oPos.g*=0.35;
}

//===========================================================================
float4 PixelShader1 (float3 position : POSITION
) : COLOR {

    float const5 = 0.125;
    return float4(const5, const5, const5, 1);
}

technique T0 < string SortTri = "Off"; > {
    pass P0 <
    > {
        CullMode         = none;
        AlphaBlendEnable = true;
        AlphaTestEnable  = false;
        SrcBlend         = one;
        DestBlend        = one;
        BlendOp          = add;
        PixelShader      = compile ps_1_1 PixelShader1();
        VertexShader     = compile vs_1_1 VertexShader1();
        FillMode         = wireframe;
    }
}
