#ifndef _MIRC_H_
#define _MIRC_H_

#include <windows.h>
#include <stdlib.h>

#define MIRC_RET_HALT		0x00
#define MIRC_RET_CONTINUE	0x01
#define MIRC_RET_PERFORM	0x02
#define MIRC_RET_DATA		0x03

#define MIRC_RETURN(Ret)	{ lstrcpy(data,Ret); lstrcat(data, "\0"); return MIRC_RET_DATA; }
#define MIRC_PARAMS			HWND mWnd, HWND aWnd, char *data, char *parms, BOOL show, BOOL nopause
#define MIRC_FUNCTION(Func)	extern "C" int WINAPI Func(MIRC_PARAMS)
#define MIRC_FALSE			"$false"
#define MIRC_TRUE			"$true"
#define MIRC_DLLINFO_BUTTONS MB_OK | MB_ICONINFORMATION
#define MIRC_DLLINFO_TITLE	"DLL Info"
#define MIRC_DLLINFO_TEXT	"mIRC Fullscreen DLL by Str3iber\nVersion 1.0\nContact: str3iber@gmx.de"

void	mircApiInit			( HWND );
void	mircApiClose		( );
void	mircApiMDISize		( );
bool	mircApiCommand		( LPSTR );
int		mircApiGetInt		( LPSTR );
LPSTR	mircApiEvaluate		( LPSTR );

LRESULT CALLBACK mircApiMainProc	( HWND, UINT, WPARAM, LPARAM );
LRESULT CALLBACK mircApiProc		( HWND, UINT, WPARAM, LPARAM );
BOOL	CALLBACK mircApiMDIProc		( HWND, LPARAM);

typedef struct {
	DWORD  mVersion;
	HWND   mHwnd;
	BOOL   mKeep;
} LOADINFO;

typedef struct
{
	HANDLE	hFileMap;
	LPSTR	mData;

	HWND	mainWnd;
	HWND	toolWnd;
	HWND	sbarWnd;

	BOOL	bToolHide;
	BOOL	bSbarHide;

	WNDPROC	procMirc;
	WNDPROC	procDLL;
	WNDPROC procChild;

	int		sbarPos;

	HWND	mdiWnd;
	BOOL	mdiMax;

} mIRCApi;

extern mIRCApi api;


class mIRCClass
{
	public:

		mIRCClass(LOADINFO*, BOOL);
		virtual ~mIRCClass(VOID);

		VOID	CloseConnection();

	private:

		HWND	hwndMain;
		HWND	hwndMDI;
		HWND	hwndToolbar;
		HWND	hwndSwitchbar;

		BOOL	bIsToolbarVisible;
		BOOL	bIsSwitchbarVisible;
		BOOL	bIsMDIMaximized;

		INT		SwitchbarPosition;

		DWORD	dwVersion;

		HANDLE	hFileMap;
		LPSTR	lpData;

		WNDPROC	prcMain;
		WNDPROC	prcDLL;
		WNDPROC prcChild;
};

#endif