
#include <irrlicht.h>
#include <iostream>

using namespace irr;

using namespace core;
using namespace scene;
using namespace video;
using namespace io;
using namespace gui;

IrrlichtDevice* device = 0;
bool UseHighLevelShaders = false;

class MyShaderCallBack : public video::IShaderConstantSetCallBack
{
public:

	virtual void OnSetConstants(video::IMaterialRendererServices* services)
	{
		video::IVideoDriver* driver = services->getVideoDriver();

		core::matrix4 invWorld = driver->getTransform(video::ETS_WORLD);
		invWorld.makeInverse();

		if (UseHighLevelShaders)
			services->setVertexShaderConstant("mInvWorld", &invWorld.M[0], 16);
		else
			services->setVertexShaderConstant(&invWorld.M[0], 0, 4);


		core::matrix4 worldViewProj;
		worldViewProj = driver->getTransform(video::ETS_PROJECTION);			
		worldViewProj *= driver->getTransform(video::ETS_VIEW);
		worldViewProj *= driver->getTransform(video::ETS_WORLD);

		if (UseHighLevelShaders)
			services->setVertexShaderConstant("mWorldViewProj", &worldViewProj.M[0], 16);
		else
			services->setVertexShaderConstant(&worldViewProj.M[0], 4, 4);		


		core::vector3df pos = device->getSceneManager()->
			getActiveCamera()->getAbsolutePosition();

		if (UseHighLevelShaders)
			services->setVertexShaderConstant("mLightPos", reinterpret_cast<f32*>(&pos), 3);
		else
			services->setVertexShaderConstant(reinterpret_cast<f32*>(&pos), 8, 1);


		video::SColorf col(0.0f,1.0f,1.0f,0.0f);

		if (UseHighLevelShaders)
			services->setVertexShaderConstant("mLightColor", reinterpret_cast<f32*>(&col), 4);
		else
			services->setVertexShaderConstant(reinterpret_cast<f32*>(&col), 9, 1);

			
		core::matrix4 world = driver->getTransform(video::ETS_WORLD);
		world = world.getTransposed();

		if (UseHighLevelShaders)
			services->setVertexShaderConstant("mTransWorld", &world.M[0], 16);
		else
			services->setVertexShaderConstant(&world.M[0], 10, 4);
	}
};


int main()
{
	device = createDevice(video::EDT_OPENGL, core::dimension2d<s32>(640, 480));

	video::IVideoDriver* driver = device->getVideoDriver();
	scene::ISceneManager* smgr = device->getSceneManager();
	gui::IGUIEnvironment* gui = device->getGUIEnvironment();

	video::IGPUProgrammingServices* gpu = driver->getGPUProgrammingServices();
	s32 newMaterialType1 = 0;
	s32 newMaterialType2 = 0;

	MyShaderCallBack* mc = new MyShaderCallBack();
	newMaterialType2 = gpu->addShaderMaterialFromFiles("opengl.vsh",
		"opengl.psh", mc, video::EMT_TRANSPARENT_ADD_COLOR);
	mc->drop();
	
	
	scene::ISceneNode* cub_m;
	scene::ISceneNode* cub_1;
	scene::ISceneNode* cub_2;
	scene::ISceneNode* cub_3;
	scene::ISceneNode* cub_4;



	scene::ISceneNode* node;
	scene::ISceneNodeAnimator* anim;

	core::array< video::ITexture * > arr_tex;
	arr_tex.insert(driver->getTexture("portal1.bmp"));
	arr_tex.insert(driver->getTexture("portal2.bmp"));
	arr_tex.insert(driver->getTexture("portal3.bmp"));
	arr_tex.insert(driver->getTexture("portal4.bmp"));
	arr_tex.insert(driver->getTexture("portal5.bmp"));
	arr_tex.insert(driver->getTexture("portal6.bmp"));
	arr_tex.insert(driver->getTexture("portal7.bmp"));
	arr_tex.insert(driver->getTexture("portal6.bmp"));
	arr_tex.insert(driver->getTexture("portal5.bmp"));
	arr_tex.insert(driver->getTexture("portal4.bmp"));
	arr_tex.insert(driver->getTexture("portal3.bmp"));
	arr_tex.insert(driver->getTexture("portal2.bmp"));

	core::array< video::ITexture * > arr_tex2;
	arr_tex2.insert(driver->getTexture("1.jpg"));
	arr_tex2.insert(driver->getTexture("2.jpg"));
	arr_tex2.insert(driver->getTexture("3.jpg"));
	arr_tex2.insert(driver->getTexture("4.jpg"));
	arr_tex2.insert(driver->getTexture("5.jpg"));
	arr_tex2.insert(driver->getTexture("6.jpg"));
	arr_tex2.insert(driver->getTexture("7.jpg"));
	arr_tex2.insert(driver->getTexture("8.jpg"));
	arr_tex2.insert(driver->getTexture("9.jpg"));
	arr_tex2.insert(driver->getTexture("10.jpg"));
	arr_tex2.insert(driver->getTexture("11.jpg"));
	arr_tex2.insert(driver->getTexture("12.jpg"));
	arr_tex2.insert(driver->getTexture("13.jpg"));
	arr_tex2.insert(driver->getTexture("12.jpg"));
	arr_tex2.insert(driver->getTexture("11.jpg"));
	arr_tex2.insert(driver->getTexture("10.jpg"));
	arr_tex2.insert(driver->getTexture("9.jpg"));
	arr_tex2.insert(driver->getTexture("8.jpg"));
	arr_tex2.insert(driver->getTexture("7.jpg"));
	arr_tex2.insert(driver->getTexture("6.jpg"));
	arr_tex2.insert(driver->getTexture("5.jpg"));
	arr_tex2.insert(driver->getTexture("4.jpg"));
	arr_tex2.insert(driver->getTexture("3.jpg"));
	arr_tex2.insert(driver->getTexture("2.jpg"));

	cub_1=node = smgr->addTestSceneNode(50);
	node->setPosition(core::vector3df(-165,0,0));
	node->setMaterialType((video::E_MATERIAL_TYPE)newMaterialType2);
	anim = smgr->createRotationAnimator(core::vector3df(0.5,0.3f,0));
	node->addAnimator(anim);
	anim = smgr->createTextureAnimator(arr_tex,300);
	node->addAnimator(anim);
	anim->drop();

	cub_2=node = smgr->addTestSceneNode(50);
	node->setPosition(core::vector3df(-90,0,0));
	node->setMaterialType((video::E_MATERIAL_TYPE)newMaterialType2);
	anim = smgr->createRotationAnimator(core::vector3df(0.1,0.4f,0));
	node->addAnimator(anim);
	anim = smgr->createTextureAnimator(arr_tex,300);
	node->addAnimator(anim);
	anim->drop();

	cub_m=node = smgr->addTestSceneNode(70);
	node->setPosition(core::vector3df(0,0,0));
	anim = smgr->createRotationAnimator(core::vector3df(0.1,0.4f,0.5f));
	node->addAnimator(anim);
	anim = smgr->createTextureAnimator(arr_tex2,300);
	node->addAnimator(anim);
	anim->drop();

	cub_3=node = smgr->addTestSceneNode(50);
	node->setPosition(core::vector3df(90,0,0));
	node->setMaterialType((video::E_MATERIAL_TYPE)newMaterialType2);
	anim = smgr->createRotationAnimator(core::vector3df(0.6,0.2f,0));
	node->addAnimator(anim);
	anim = smgr->createTextureAnimator(arr_tex,300);
	node->addAnimator(anim);
	anim->drop();

	cub_4=node = smgr->addTestSceneNode(50);
	node->setPosition(core::vector3df(165,0,0));
	node->setMaterialType((video::E_MATERIAL_TYPE)newMaterialType2);
	anim = smgr->createRotationAnimator(core::vector3df(0.2,0.3f,0));
	node->addAnimator(anim);
	anim = smgr->createTextureAnimator(arr_tex,300);
	node->addAnimator(anim);
	anim->drop();


	IGUIImage* img = gui->addImage( 
					driver->getTexture("text-cc_fix.jpg"),position2d<int>(0,40) );
	IGUIImage* img2 = gui->addImage( 
					driver->getTexture("text-cc_fix.jpg"),position2d<int>(1600,40) );

	IGUIImage **ll=new IGUIImage*[25];
	for (int i=0; i<32; i+=2)
		ll[i] = gui->addImage( driver->getTexture("ll.png"),position2d<int>(i*20,480) );

	for (int i=1; i<32; i+=2)
		ll[i] = gui->addImage( driver->getTexture("ll.png"),position2d<int>(i*20,-480) );

	scene::ICameraSceneNode* cam = smgr->addCameraSceneNode();
	cam->setPosition(core::vector3df(0,0,250));
	cam->setTarget(core::vector3df(0,0,0));

	scene::ILightSceneNode* light = 0;

	light = device->getSceneManager()->addLightSceneNode(0,
		core::vector3df(100,100,0),	video::SColorf(1.0f, 0.5f, 0.5f, 1.0f), 1500);


	cub_m->setVisible(false);
	cub_1->setVisible(false);
	cub_2->setVisible(false);
	cub_3->setVisible(false);
	cub_4->setVisible(false);


	int lastFPS = -1;
	float dx=1;
	int sch=0;
	int mno=-1;
	int qwe=0;
	int sch2=0;

	while(device->run())
		if (device->isWindowActive())
	{

		driver->beginScene(true, true, video::SColor(255,0,0,0));
		gui->drawAll();
		smgr->drawAll();
		driver->endScene();

		sch2++;
		sch++;
		if (sch>1600)
		{
				sch=0;
				mno=-mno;
				if (mno==1) img->move( position2d<s32>( 3200, 0) );
				if (mno==-1) img2->move( position2d<s32>( 3200, 0) );
		}

		int fps = driver->getFPS();
		img->move( position2d<s32>( -dx, 0) );
		img2->move( position2d<s32>( -dx, 0) );

		if (sch2>2000) cub_1->setVisible(true);
		if (sch2>4000) cub_4->setVisible(true);
		if (sch2>6000) cub_3->setVisible(true);
		if (sch2>8000) cub_2->setVisible(true);
		if (sch2>10000) cub_m->setVisible(true);

		if (sch2>12000){
			qwe++;
			if (qwe>2000){
				for (int i=0; i<32; i+=2)
					ll[i] -> move( position2d<s32>( 0, -1) );
				for (int i=1; i<32; i+=2)
					ll[i] -> move( position2d<s32>( 0, 1) );
				if (qwe>2420) qwe=0;
			}
		}

		if (lastFPS != fps)
		{
		  core::stringw str = L"Irrlicht Engine - Chaos Construction '07 [";
		  str += driver->getName();
		  str += "] FPS:";
		  str += fps;

		  device->setWindowCaption(str.c_str());
		  lastFPS = fps;
		}
	}

	device->drop();
	
	return 0;
}
