

float blur : FXBLUR = 0.02;
float butterInGlass : FXBUTTERINGLASS = 0.2;
float cutFade : FXCUT = 0;
float darkFade : FXDARK = 0;
float lightFade : FXLIGHT = 0;
texture2D shadeTex;
texture2D depthDistTex;
texture2D finalTex;


sampler2D shadeSamp = sampler_state{
	texture = <shadeTex>;
	magfilter = point;
	minfilter = point;
	mipfilter = none;
	addressu = clamp;
	addressv = clamp;
};

sampler2D depthSamp = sampler_state{
	texture = <depthDistTex>;
	magfilter = linear;
	minfilter = point;
	mipfilter = none;
	addressu = clamp;
	addressv = clamp;
};

sampler2D finalSamp = sampler_state{
	texture = <finalTex>;
	magfilter = linear;
	minfilter = point;
	mipfilter = none;
	addressu = clamp;
	addressv = clamp;
};



struct VertexInput{
	float4 position: POSITION;
	float2 texcoord: TEXCOORD;
};


struct VertexOutput{
	float4 position: POSITION;
	float2 texcoord: TEXCOORD;
};


VertexOutput vsAdd(VertexInput input){
	VertexOutput output = (VertexOutput)0;
	
	output.position.xy = sign(input.position.xy);
	output.position.zw = float2(0,1);
	output.texcoord = input.texcoord;
	
	return output;
}


static const float off = 1.0/800.0;

float4 psOutline(VertexOutput input):COLOR0{
	float3 shadeColor = tex2D(shadeSamp, input.texcoord);
	
	float4 s00 = tex2D(depthSamp, input.texcoord + float2(-off, -off));
	float4 s01 = tex2D(depthSamp, input.texcoord + float2( 0,   -off));
	float4 s02 = tex2D(depthSamp, input.texcoord + float2( off, -off));

	float4 s10 = tex2D(depthSamp, input.texcoord + float2(-off,  0));
	float4 s12 = tex2D(depthSamp, input.texcoord + float2( off,  0));

	float4 s20 = tex2D(depthSamp, input.texcoord + float2(-off,  off));
	float4 s21 = tex2D(depthSamp, input.texcoord + float2( 0,    off));
	float4 s22 = tex2D(depthSamp, input.texcoord + float2( off,  off));
	
	float4 sobelX = s00 + 2 * s10 + s20 - s02 - 2 * s12 - s22;
	float4 sobelY = s00 + 2 * s01 + s02 - s20 - 2 * s21 - s22;
	
	float4 edgeSqr = sobelX * sobelX + sobelY * sobelY;
	
	float ink = 1 - pow(dot(edgeSqr, 1), 4);

	return float4(ink * shadeColor, 0);
}


float4 psReduce(VertexOutput input):COLOR0{
	float4 color = tex2D(finalSamp, input.texcoord);
	return float4(color.rgb*(color.a+butterInGlass), 0);
}


float4 psBlur(VertexOutput input, uniform bool vertical):COLOR0{
	float4 color = 0;
	
	float2 off = 0;
	if(vertical)
		off = float2(0, blur);
	else
		off = float2(blur, 0);
		
	color += tex2D(finalSamp, input.texcoord + off * -1) * 1;
	color += tex2D(finalSamp, input.texcoord + off * -0.6) * 1.8;
	color += tex2D(finalSamp, input.texcoord + off * -0.3) * 3.8;
	
	color += tex2D(finalSamp, input.texcoord + off) * 5;
	
	color += tex2D(finalSamp, input.texcoord + off * 0.3) * 3.8;
	color += tex2D(finalSamp, input.texcoord + off * 0.6) * 1.8;
	color += tex2D(finalSamp, input.texcoord + off * 1) * 1;
	
	return color / 18.2;
}


float4 psFinal(VertexOutput input):COLOR0{
	float4 glowColor = tex2D(finalSamp, input.texcoord);
	float4 sceneColor = tex2D(shadeSamp, input.texcoord);
	
	float4 final = sceneColor*saturate(-butterInGlass*2+2) + glowColor;
	
	return (final-cutFade)*(1-darkFade) + lightFade;
}


technique InkEffect{
	pass outline{
		cullmode = none;
		zenable = false;
		zwriteenable = false;
		
		vertexShader = compile vs_1_1 vsAdd();
		pixelShader = compile ps_2_0 psOutline();
	}
	
	pass reduce{
		cullmode = none;
		zenable = false;
		zwriteenable = false;
		
		vertexShader = compile vs_1_1 vsAdd();
		pixelShader = compile ps_2_0 psReduce();
	}
	
	pass blurh{
		cullmode = none;
		zenable = false;
		zwriteenable = false;
		alphablendenable = true;
		vertexshader = compile vs_1_1 vsAdd();
		pixelshader = compile ps_2_0 psBlur(false);
	}
	
	pass blurv{
		cullmode = none;
		zenable = false;
		zwriteenable = false;
		alphablendenable = true;
		vertexshader = compile vs_1_1 vsAdd();
		pixelshader = compile ps_2_0 psBlur(true);
	}
	
	pass final{
		cullmode = none;
		zenable = false;
		zwriteenable = false;
		
		vertexShader = compile vs_1_1 vsAdd();
		pixelShader = compile ps_2_0 psFinal();
	}
}
