
varying vec3 Vnormal;
varying vec3 pos;
varying vec3 view;
varying vec4 camn;

uniform sampler2D tex;
uniform sampler2D normaltex;
uniform float time;
uniform float globalTexMul;
uniform float width;
uniform float height;

const float timeMul = 0.0015*3.14159;
const float normTexMul1 = 128.0;
const float normTexMul2 = 64.0;
const float normTexMul3 = 32.0;
const float normMul = 16.0;
const vec3 baseCol = vec3(0.65, 0.75, 0.80);

void main() {
	vec2 tc = gl_TexCoord[0].xy*globalTexMul;
	tc.y -= time*timeMul;
	vec3 normal = texture2D(normaltex, tc*normTexMul1).xyz*1.0;
	tc.y -= time*timeMul;
	normal += texture2D(normaltex, tc*normTexMul2).xyz*2.0;
	tc.y -= time*timeMul;
	normal += texture2D(normaltex, tc*normTexMul3).xyz*4.0;
	normal = -1.0+2.0*normalize(normal);
	vec2 norm = normal.xy/normal.z;

	float dotsu = dot(normal, normalize(vec3(0.0, -0.5, 1.0)));
	dotsu = 1.0-dotsu*dotsu;

	vec2 texy = vec2(gl_FragCoord.x/width, gl_FragCoord.y/height);
	texy += vec2(norm.x*normMul/width, norm.y*normMul/height);

	vec3 col = texture2D(tex, texy).rgb*baseCol*dotsu*2.0;
	
	gl_FragColor = vec4(col, 0.5);

}
