uniform vec3 camPos;
uniform mat4 modelWorld4x4;

varying vec3 normal;
varying vec4 worldPos;
varying mat3 modelWorld3x3;

mat3 GetLinearPart(mat4 m)
{
	mat3 result;

	result[0][0] = m[0][0];
	result[0][1] = m[0][1];
	result[0][2] = m[0][2];

	result[1][0] = m[1][0];
	result[1][1] = m[1][1];
	result[1][2] = m[1][2];

	result[2][0] = m[2][0];
	result[2][1] = m[2][1];
	result[2][2] = m[2][2];

	return result;
}




void main()
{
	gl_Position = ftransform();
	//gl_ClipVertex = gl_ModelViewMatrix * gl_Vertex;


	modelWorld3x3 = GetLinearPart(modelWorld4x4);
	normal = normalize(modelWorld3x3 * gl_Normal);
	//normal = normalize(gl_Normal);

	//gl_TexCoord[0] = gl_TextureMatrix[0] * gl_MultiTexCoord0;
	gl_TexCoord[0] = gl_MultiTexCoord0;



	worldPos = modelWorld4x4 * gl_Vertex;


}
