float4x4 matWorldViewProjection;
float4x4 matLightViewProjection;
float4x4 matView;
float4x4 matWorld;

float FarClip = 0.f; //depth i linjetegner

float3 LightPosition = {0.f, 100.f, 0.f};
float3 LightTarget = {0.f, 0.f, 0.f};

texture tex0; //spotlight
texture tex1; //diffuse
texture tex2; //shadowmap (depthmap)
texture tex3; //depthmap

bool SHADOWS = true; //need shadowmap

sampler2D SpotLight =
sampler_state
{
	texture = (tex0);
	MipFilter = None; MinFilter = Linear; MagFilter = Linear;
	AddressV = Clamp; AddressU = Clamp; 
};

sampler2D Diffuse = 
sampler_state
{
	texture = (tex1);
	MipFilter = None; MinFilter = Linear; MagFilter = Linear;
	AddressV = Wrap; AddressU = Wrap; 
};

sampler2D ShadowMap =
sampler_state
{
	texture = (tex2);
	MipFilter = None; MinFilter = Linear; MagFilter = Linear;
	AddressV = Clamp; AddressU = Clamp; 
};

sampler2D DepthMap = 
sampler_state
{
	texture = (tex3);
	MipFilter = None; MinFilter = Point; MagFilter = Point; 
	AddressV = Clamp; AddressU = Clamp; 
};

void vs_spotlight(in float4 ipos : POSITION,
				  in float3 inormal : NORMAL,
				  in float2 itex : TEXCOORD0,
				  out float4 opos : POSITION,
				  out float2 otex : TEXCOORD0,
				  out float3 onormal : TEXCOORD1,
				  out float4 lightpos : TEXCOORD2,
				  out float3 lightdir : TEXCOORD3,
				  out float2  depth : TEXCOORD4)
{
	opos = mul(ipos, matWorldViewProjection);
	onormal = mul(inormal, matView);
	otex = itex;
	lightpos = mul(mul(ipos, matWorld), matLightViewProjection);
	lightdir = normalize(LightPosition - mul(ipos, matView));
	
	float4 worldtrans = mul(ipos, matWorld);
	depth.x =  min(length(mul(worldtrans, matLightViewProjection))/FarClip, 1);
	depth.y = 1.f;
	//depth.y =  length (LightTarget - worldtrans);//min(length(mul(ipos, matWorldViewProjection))/FarClip, 1);
}

//use only for lines
float4 ps_spotlightDiffuse(in float2 tex : TEXCOORD0, 
						   in float4 lightpos : TEXCOORD2,
						   in float2 depth : TEXCOORD4) : COLOR0
{
	float2 texLight = 0.5 * lightpos.xy / lightpos.w + float2( 0.5, 0.5 );
    texLight.y = 1.f - texLight.y; 
    
    float Shadow = depth.x > tex2D(DepthMap, texLight)+.004f ? (tex2D(ShadowMap, texLight).r) : 1.f;
	float Lighting = tex2D(SpotLight, texLight);
	float4 pixel = (tex2D(Diffuse, tex)*Lighting)*Shadow;
	pixel.a = 1.f;
	//if in lightcone
//	if( depth.y > NearTreshold)
//	if( Lighting.r < 0.01f)
//		pixel.a = 0.f;
	return pixel;
}

float4 ps_spotlightDiffuseShadowLight(in float2 tex : TEXCOORD0, 
								in float3 normal : TEXCOORD1, 
								in float4 lightpos : TEXCOORD2,
								in float3 lightdir : TEXCOORD3) : COLOR0
{
	float2 texLight = 0.5 * lightpos.xy / lightpos.w + float2( 0.5, 0.5 );
    texLight.y = 1.f - texLight.y; 
    float NdotL = dot(normal, lightdir);
    float Shadow = tex2D(ShadowMap, texLight);
	return (tex2D(Diffuse, tex)*tex2D(SpotLight, texLight)*NdotL)*Shadow;
}

float4 ps_spotlightDiffuseLight(in float2 tex : TEXCOORD0, 
								in float3 normal : TEXCOORD1, 
								in float4 lightpos : TEXCOORD2,
								in float3 lightdir : TEXCOORD3) : COLOR0
{
	float2 texLight = 0.5 * lightpos.xy / lightpos.w + float2( 0.5, 0.5 );
    texLight.y = 1.f - texLight.y; 
    float NdotL = dot(normal, lightdir);
	return (tex2D(Diffuse, tex)*tex2D(SpotLight, texLight)*NdotL);
}

float4 ps_spotlightDiffuseSpot(in float2 tex : TEXCOORD0, 
							   in float4 lightpos : TEXCOORD2) : COLOR0
{
	float2 texLight = 0.5 * lightpos.xy / lightpos.w + float2( 0.5, 0.5 );
    texLight.y = 1.f - texLight.y; 
    return (tex2D(Diffuse, tex)*tex2D(SpotLight, texLight));
}

technique Spotlight
{
	pass Diffuse
	{
		VertexShader = compile vs_2_0 vs_spotlight();
		PixelShader  = compile ps_2_0 ps_spotlightDiffuse();
	}
	
	pass DiffuseLightShadow
	{
		VertexShader = compile vs_2_0 vs_spotlight();
		PixelShader  = compile ps_2_0 ps_spotlightDiffuseShadowLight();
	}
	
	pass DiffuseLight 
	{
		VertexShader = compile vs_2_0 vs_spotlight();
		PixelShader = compile ps_2_0 ps_spotlightDiffuseLight();
	}
	
	pass DiffuseSpot
	{
		VertexShader = compile vs_2_0 vs_spotlight();
		PixelShader = compile ps_2_0 ps_spotlightDiffuseSpot();
	}
	
}