float4x4 matWorldViewProjection; 
float4x4 matView;
float anim; 

float3 CameraPosition = {0.f, 100.f, 0.f};
float3 LightPosition = {50.f, 50.f, 50.f};

texture tex0;

sampler2D a = 
sampler_state
{
	texture = (tex0);
	MipFilter = None; MagFilter = Linear; MinFilter = Linear;
	AddressU = Wrap; AddressV = Wrap;
};

void vs_texture(in float4 ipos : POSITION,
			    in float2 itex : TEXCOORD0,
			    out float4 opos : POSITION,
			    out float2 otex : TEXCOORD0,
			    out float4 cpos : TEXCOORD1)
{
//	ipos.z = 40.f*sin(ipos.x*.02f*ipos.y*.02f+anim);
	opos = mul(ipos, matWorldViewProjection);
	otex = itex;
	cpos = opos;
}

float4 ps_texture(in float2 tex : TEXCOORD0,
				  in float4 cpos : TEXCOORD1) : COLOR0
{
	float2 rtex = .5f * cpos.xy / cpos.w + float2(.5f, .5f);
	rtex.y = 1.f - rtex.y;
	//return float4(1.f, 1.f, 0.f, 1.f);
	return tex2D(a, rtex);
}

technique Texture
{
	pass p0
	{
		VertexShader = compile vs_2_0 vs_texture();
		PixelShader  = compile ps_2_0 ps_texture(); 
	}
}