float4x4 matWorldViewProjection; 
texture tex0;  //a

//pass 0 1
float anim = 0.f;

//pass1
float amplitude = .01f;
float freq = 1000.f; 

sampler2D a = 
sampler_state
{
	texture = (tex0);
	MipFilter = Linear; MagFilter = Linear; MinFilter = Linear;
	AddressU = Clamp; AddressV = Clamp;
};


void vs_sindisortion(in float4 ipos : POSITION,
			    in float2 itex : TEXCOORD0,
			    out float4 opos : POSITION,
			    out float2 otex : TEXCOORD0)
{
	opos = mul(ipos, matWorldViewProjection);
	otex = itex; 
	otex.y += 1.f;
	
	float dx = otex.x-.9f;
	float dy = otex.y-.1f;
	float dist = sqrt(dx*dx+dy*dy);
	float hore = .05f*tan(dist * 1.f - (anim - 1.57079));
	otex.x += hore*dx;
	otex.y += hore*dy;
}

float4 ps_texture(in float2 tex : TEXCOORD0) : COLOR0
{
	float4 pixel = {0.f, 0.f, 0.f, 1.f};
	if(tex.x>0.f && tex.y>0.f && tex.y<1.f)
		pixel = tex2D(a, tex);
	return pixel;
}

float4 ps_sin(in float2 tex: TEXCOORD0) : COLOR0
{
	tex.x += amplitude*sin(tex.y*freq+anim);
	return tex2D(a, tex)*max(1.f, amplitude*100.f);
}

void vs_straight(in float4 ipos : POSITION,
					 in float2 itex : TEXCOORD0,
					 out float4 opos : POSITION, 
					 out float2 otex :TEXCOORD0)
{
	opos = mul(ipos, matWorldViewProjection);
	otex = itex;
	otex.y += 1.f;
}

technique Texture
{
	pass p0  //blge over skjermen fra valgtpunkt
	{
		VertexShader = compile vs_2_0 vs_sindisortion();
		PixelShader  = compile ps_2_0 ps_texture(); 
	}
	
	pass p1
	{
		VertexShader = compile vs_2_0 vs_straight();
		PixelShader  = compile ps_2_0 ps_sin();
	}
}