float4x4 matProjection;

texture tex0;
float pump = 0.f;

sampler2D a = 
sampler_state 
{
	texture = (tex0);
	MipFilter = Linear; MinFilter = Linear; MagFilter = Linear;
	AddressV = Clamp; AddressU = Clamp; 
};

void vs_main(in float4 ipos : POSITION, 
			    in float2 itex : TEXCOORD0,
			    out float4 opos : POSITION,
			    out float2 otex : TEXCOORD0,
			    out float alpha : TEXCOORD1)
{
	opos = mul(ipos, matProjection);
	otex = itex;
	otex.y += 1.f;
	alpha = 1.f;
	
}

float4 ps_single(in float2 itex : TEXCOORD0,
				 in float alpha : TEXCOORD1) : COLOR0
{
	float4 pixel = tex2D(a, itex);
	return pixel;
}

float4 ps_pump(in float2 itex : TEXCOORD0,
				 in float alpha : TEXCOORD1) : COLOR0
{

	float dx = itex.x-.5f;
	float dy = itex.y-.5f;
	float dist = sqrt(dx*dx+dy*dy);
	float hore = .05f*tan(dist * 1.f - (pump- 1.57079));
	itex.x += hore*dx;
	itex.y += hore*dy;
	float4 pixel = tex2D(a, itex);
	return pixel;
}

technique Div
{
	pass Singel
	{
		VertexShader = compile vs_2_0 vs_main();
		PixelShader  = compile ps_2_0 ps_single();
	}
	
	pass OrganPump
	{
		VertexShader = compile vs_2_0 vs_main();
		PixelShader  = compile ps_2_0 ps_pump();
	}
}