float4x4 matWorldViewProjection;
float4x4 matLightViewProjection; 
float4x4 matView;
float alpha1 = 1.f;
texture tex0;
texture tex1;
float treshold = 1.f; //render3 demo2 clean

float3 LightPosition = {0.f, 200.f, 0.f};
sampler2D a = 
sampler_state 
{
	texture = (tex0);
	MipFilter = Linear; MinFilter = Linear; MagFilter = Linear;
	AddressV = Wrap; AddressU = Wrap; 
};
sampler2D b = 
sampler_state 
{
	texture = (tex1);
	MipFilter = Linear; MinFilter = Linear; MagFilter = Linear;
	AddressV = Wrap; AddressU = Wrap; 
};

void vs_main(in float4 ipos : POSITION, 
			 in float3 inormal : NORMAL,
			 in float2 itex : TEXCOORD0,
			    
			    out float4 opos : POSITION,
			    out float2 otex : TEXCOORD0,
			    out float3 onormal : TEXCOORD1,
			    out float3 lightdir : TEXCOORD2)
{
	opos = mul(ipos, matWorldViewProjection);
	otex = itex;
	onormal = mul(inormal, matView);
	lightdir = normalize(LightPosition - mul(ipos, matView));
}

void vs_shadow(in float4 ipos : POSITION,
			   in float2 itex : TEXCOORD0,
			   
			   out float4 opos : POSITION,
			   out float2 otex : TEXCOORD0)
{
	opos = mul(ipos, matLightViewProjection);
	otex = itex;
}

float4 ps_single(in float2 itex : TEXCOORD0,
				 in float3 normal : TEXCOORD1,
				 in float3 lightdir : TEXCOORD2) : COLOR0
{
	float NdotL = abs(dot(normal, lightdir));
	return tex2D(a, itex)*NdotL;
}

float4 ps_shadow(in float2 itex : TEXCOORD0) : COLOR0
{
	return tex2D(a, itex); 
}

float4 ps_clean(in float2 tex : TEXCOORD0) : COLOR0
{
	float4 pixel = tex2D(a, tex);
	float alpha = tex2D(b, tex).r;
	
	if(alpha > treshold)
		alpha = 1.f;
	else
		alpha = 0.f;
	return float4(pixel.xyz, alpha); 
}

technique Div
{
	pass Diffus //diffuse + normallight
	{
		VertexShader = compile vs_2_0 vs_main();
		PixelShader  = compile ps_2_0 ps_single();
	}
	
	pass Shadow
	{
		VertexShader = compile vs_2_0 vs_shadow();
		PixelShader  = compile ps_2_0 ps_shadow();	
	}
	
	pass Clean //render3 demo2
	{
		VertexShader = compile vs_2_0 vs_main();
		PixelShader  = compile ps_2_0 ps_clean();
	}
}