float4x4 matProjection;

float alpha1 = 1.f;
float alpha2 = 1.f;
float alpha3 = 1.f;
float time; 

texture tex0;
texture tex1;
texture tex2;
sampler2D a = 
sampler_state 
{
	texture = (tex0);
	MipFilter = Linear; MinFilter = Linear; MagFilter = Linear;
	AddressV = Wrap; AddressU = Wrap; 
};
sampler2D b = 
sampler_state 
{
	texture = (tex1);
	MipFilter = Linear; MinFilter = Linear; MagFilter = Linear;
	AddressV = Wrap; AddressU = Wrap; 
};
sampler2D c = 
sampler_state 
{
	texture = (tex2);
	MipFilter = Linear; MinFilter = Linear; MagFilter = Linear;
	AddressV = Wrap; AddressU = Wrap; 
};

void vs_main(in float4 ipos : POSITION, 
			    in float2 itex : TEXCOORD0,
			    out float4 opos : POSITION,
			    out float2 otex : TEXCOORD0)
{
	opos = mul(ipos, matProjection);
	otex = itex;
}

float4 ps_single(in float2 itex : TEXCOORD0) : COLOR0
{
	return tex2D(a, itex)*alpha1;
}

float4 ps_tridraw(in float2 itex : TEXCOORD0) : COLOR0
{	
	float4 pixelA = tex2D(a, itex);
	float4 pixelB = tex2D(b, itex);
	float4 pixelC = tex2D(c, itex);
	pixelA.rgba *= pixelA.a*alpha1;
	pixelB.rgba *= pixelB.a*alpha2;
	pixelC.rgba *= pixelC.a*alpha3;
	return float4((pixelA+pixelB+pixelC).rgb, pixelA.a + pixelB.a + pixelC.a );
}

technique Div
{
	pass Singel
	{
		VertexShader = compile vs_2_0 vs_main();
		PixelShader  = compile ps_2_0 ps_single();
	}
	pass TriDraw 
	{
		VertexShader = compile vs_2_0 vs_main();
		PixelShader  = compile ps_2_0 ps_tridraw(); 
	}
}