float4x4 matWorldViewProjection; 
float4x4 matLightViewProjection;
float4x4 matView; 
float3  LightPosition = {0.f, 100.f, 0.f};

texture tex0;  //spotlight
texture tex1;  //diffuse
texture tex2;  //shadowmap

float alpha1 = 1.f; //pass1 aktuell

sampler2D a = 
sampler_state
{
	texture = (tex0);
	MipFilter = None; MagFilter = Point; MinFilter = Point;	
	AddressU = Clamp; AddressV = Clamp;
};

sampler2D b = 
sampler_state
{
	texture = (tex1);
	MipFilter = Linear;	MagFilter = Linear;	MinFilter = Linear; 
	AddressU = Clamp; AddressV = Clamp;
};

sampler2D c = 
sampler_state
{
	texture = (tex2);
	MipFilter = None; MagFilter = Linear;	MinFilter = Linear; 
	AddressU = Clamp; AddressV = Clamp;
};

void vs_kubegrid(in float4 ipos : POSITION,
			     in float2 itex : TEXCOORD0,
			     in float3 inormal : NORMAL,
			    out float4 opos : POSITION,
			    out float2 otex : TEXCOORD0,
			    out float3 onormal : TEXCOORD1,
			    out float3 lightdir : TEXCOORD2,
			    out float4 lightpos : TEXCOORD3)
{
	opos = mul(ipos, matWorldViewProjection);
	otex = itex; 
	otex.y = 1.f - otex.y;
	onormal = mul(inormal, matView);
	lightdir = normalize(LightPosition - mul(ipos, matView));
	lightpos = mul(ipos, matLightViewProjection);
}

float4 ps_kubegrid(in float2 tex : TEXCOORD0,
				   in float3 normal : TEXCOORD1,
				   in float3 lightdir : TEXCOORD2,
				   in float4 lightpos : TEXCOORD3) : COLOR0
{
	float diffuse = dot(normal, lightdir);
	float4 diffusemap = tex2D(b, tex);
	float2 lightTex = .5 * lightpos.xy/lightpos.w + float2(.5, .5f);
	lightTex.y = 1.f - lightTex.y;
	float4 spotmap = tex2D(a, lightTex);
	
	//return diffusemap;
	return (diffusemap*diffuse)*spotmap;
}

float4 ps_kubegrid2(in float2 tex : TEXCOORD0,
				   in float3 normal : TEXCOORD1,
				   in float3 lightdir : TEXCOORD2) : COLOR0
{
	float diffuse = dot(normal, lightdir);
	float4 diffusemap = tex2D(b, tex);
	
	//return diffusemap;
	return (diffusemap*diffuse)*alpha1;
}

float4 ps_kubegrid3(in float2 tex : TEXCOORD0,
				   in float3 normal : TEXCOORD1,
				   in float3 lightdir : TEXCOORD2,
				   in float4 lightpos : TEXCOORD3) : COLOR0
{
	float diffuse = dot(normal, lightdir);
	float4 diffusemap = tex2D(b, tex);
	float2 lightTex = .5 * lightpos.xy/lightpos.w + float2(.5, .5f);
	lightTex.y = 1.f - lightTex.y;
	float4 spotmap = tex2D(a, lightTex);
	float4 shadow = tex2D(c, lightTex);
	
	//return float4(1.f, 0.f, 0.f, 1.f);
	//return spotmap;
	return (diffusemap*diffuse)*spotmap*shadow;
}


technique Kube
{
	pass p0 //diffuse + nlight + spot
	{
		VertexShader = compile vs_2_0 vs_kubegrid();
		PixelShader  = compile ps_2_0 ps_kubegrid(); 
	}
	
	pass p1 //diffuse + nlight  //render2
	{
		VertexShader = compile vs_2_0 vs_kubegrid();
		PixelShader  = compile ps_2_0 ps_kubegrid2(); 
	}
	
	pass p2 //render4
	{
		VertexShader = compile vs_2_0 vs_kubegrid();
		PixelShader  = compile ps_2_0 ps_kubegrid3(); 
	}
}