float4x4	wMatrix			: World;
float4x4 	wvpMatrix 		: WorldViewProjection;
half4 		lightPos		: Light0;
float4x4	reflMatrix = float4x4( 	1.0f, 0.0f, 0.0f, 0.0f,
									0.0f, -1.0f, 0.0f, 0.0f,
									0.0f, 0.0f, 1.0f, 0.0f,
									0.0f, 0.0f, 0.0f, 1.0f  );
									
float3		diffuseColor
<
	string UIName = "Diffuse Material Color";
> = { 1.0f, 1.0f, 1.0f };

float3		ambientColor
<
	string UIName = "Ambient Material Color";
> = { 0.0f, 0.0f, 0.0f };

texture	texture_0
<
	string UIName = "Sand texture";
>;
texture	texture_1
<
	string UIName = "Grass texture";
>;
texture	texture_2
<
	string UIName = "Rock texture";
>;

sampler2D texture_0Sampler = sampler_state 
{
    texture = <texture_0>;
    AddressU  = WRAP;        
    AddressV  = WRAP;
    AddressW  = WRAP;
    MIPFILTER = LINEAR;
    MINFILTER = LINEAR;
    MAGFILTER = LINEAR;
};

sampler2D texture_1Sampler = sampler_state 
{
    texture = <texture_1>;
    AddressU  = WRAP;        
    AddressV  = WRAP;
    AddressW  = WRAP;
    MIPFILTER = LINEAR;
    MINFILTER = LINEAR;
    MAGFILTER = LINEAR;
};
sampler2D texture_2Sampler = sampler_state 
{
    texture = <texture_2>;
    AddressU  = WRAP;        
    AddressV  = WRAP;
    AddressW  = WRAP;
    MIPFILTER = LINEAR;
    MINFILTER = LINEAR;
    MAGFILTER = LINEAR;
};

struct VertexInput {
    float3 position		: POSITION;
    float2 uvCoord		: TEXCOORD0;
    float3 Normal		: NORMAL;
    float3 coefs		: TANGENT;
};

struct VertexOutput {
    float4 	position	: POSITION;
    half3 	lightDir	: TEXCOORD0;
    half3 	worldNormal	: TEXCOORD1;
    float2	uvCoord		: TEXCOORD2;
    float4	coefs		: TEXCOORD3;
};

VertexOutput VS_Diffuse(VertexInput IN) {
    VertexOutput OUT;
    
    float3 worldPos = mul(float4(IN.position,1.0f), wMatrix);
    half3 worldNormal = mul(IN.Normal, wMatrix);
    worldNormal = normalize(worldNormal);
    OUT.lightDir = lightPos - worldPos;
    OUT.worldNormal = worldNormal;
    OUT.position = mul(float4(IN.position,1.0f), wvpMatrix);
	OUT.uvCoord = IN.uvCoord;
	OUT.coefs = float4(IN.coefs,0.0f);
	
    return OUT;
}

VertexOutput VS_ReflectDiffuse(VertexInput IN) {
    VertexOutput OUT;
    
    IN.position.y = -IN.position.y;
    float3 worldPos = mul(float4(IN.position,1.0f), wMatrix);
    half3 worldNormal = mul(IN.Normal, wMatrix);
    worldNormal = normalize(worldNormal);
    OUT.lightDir = lightPos - worldPos;
    OUT.worldNormal = worldNormal;
    OUT.position = mul(float4(IN.position,1.0f), wvpMatrix);
	OUT.uvCoord = IN.uvCoord;
	OUT.coefs = float4(IN.coefs,IN.position.y);
	
    return OUT;
}

float4 PS_Diffuse( VertexOutput IN ) : COLOR
{
	float3 sand = tex2D( texture_0Sampler, IN.uvCoord );
	float3 grass = tex2D( texture_1Sampler, IN.uvCoord );
	float3 rock = tex2D( texture_2Sampler, IN.uvCoord );
	float4 final = float4( sand * IN.coefs.x + grass * IN.coefs.y + rock * IN.coefs.z, 1.0f );
	
	half3 normal =  normalize(IN.worldNormal);
	half3 lightDir = normalize(IN.lightDir);
	return float4(max(0,dot( normal, lightDir )) * diffuseColor + ambientColor,1.0f) * final;
}

float4 PS_DiffuseReflect( VertexOutput IN ) : COLOR
{
	clip( -IN.coefs.w );
	float3 sand = tex2D( texture_0Sampler, IN.uvCoord );
	float3 grass = tex2D( texture_1Sampler, IN.uvCoord );
	float3 rock = tex2D( texture_2Sampler, IN.uvCoord );
	float4 final = float4( sand * IN.coefs.x + grass * IN.coefs.y + rock * IN.coefs.z, 1.0f );
	
	half3 normal =  normalize(IN.worldNormal);
	half3 lightDir = normalize(IN.lightDir);
	return float4(max(0,dot( normal, lightDir )) * diffuseColor + ambientColor,1.0f) * final;
}

technique Reflect
{
	pass p0
	{
		VertexShader = compile vs_2_0 VS_ReflectDiffuse();
		PixelShader = compile ps_2_0 PS_DiffuseReflect();
		CullMode = cw;
	}
}

technique ps20
{
    pass p0
    {		
		VertexShader = compile vs_2_0 VS_Diffuse();
		PixelShader = compile ps_2_0 PS_Diffuse();
    }
}

