varying float depth;

uniform float focus;
float clamp_far = 1.0; //must be between 0 and 1

float ComputeDepthBlur() {
	float f;
	if(depth < focus) {
		f = (depth - focus)/(focus - gl_DepthRange.near);
	}
	else {
		f = (depth - focus)/( 300.0 - focus);
		//clamp the far blur to a maximum blurriness
		f = clamp(f, 0.0, clamp_far);
	}
	
	//scale and bias into [0,1] range
	return f * 0.5 + 0.5;
}

void main()
{
	gl_FragColor.rgb = vec3(ComputeDepthBlur());
	gl_FragColor.a = 1;
}