#ifndef VARYINGMENU_H
#define VARYINGMENU_H

#include "menubase.h"
#include <string>
#include <utility>

class MenuItem {
public:
	virtual bool handleKey(SDLKey key) = 0;
	virtual void draw() = 0;
};

/** Base class for menus with varying types
 * of items.
 * The template parameter Derived is expected
 * to implement the following interface:
 * - void draw();
 */
template<class Derived>
class VaryingMenu: public MenuBase<VaryingMenu<Derived>, std::pair<std::string, MenuItem*> > {
public:
	typedef std::pair<std::string, MenuItem*> Item;
	typedef MenuBase<VaryingMenu<Derived>, Item> Base;
	VaryingMenu() {}

	void draw() {
		static_cast<Derived*>(this)->draw();
	}
	bool processKey(SDLKey key) {
		return Base::items[Base::activeItem].second->handleKey(key);
	}
};

#endif
