/* Copyright (C) 2007  Mikko Sysikaski <mikko.sysikaski@gmail.com>
 * This program is free software distributed under GNU General Public License
 * version 3 or (at your option) any later version.
 * No warranty of any kind is provided. See the accompanying file COPYING for details.
 */

#include "sound.h"
#include "SDL_mixer.h"
#include <cstdio>

Sound Sound::m_instance;

void Sound::init(const char* menuIntro, const char* menu, const char* game)
{
	Mix_OpenAudio(MIX_DEFAULT_FREQUENCY, MIX_DEFAULT_FORMAT, 2, 1024);

	m_menuIntro = Mix_LoadMUS(menuIntro);
	if (!m_menuIntro) {
		fprintf(stderr, "Warning: couldn't load menu intro music: %s\n", Mix_GetError());
	}
	m_menu = Mix_LoadMUS(menu);
	if (!m_menu) {
		fprintf(stderr, "Warning: couldn't load menu music: %s\n", Mix_GetError());
	}
	m_game = Mix_LoadMUS(game);
	if (!m_game) {
		fprintf(stderr, "Warning: couldn't load game music: %s\n", Mix_GetError());
	}
}
