/* Copyright (C) 2007  Mikko Sysikaski <mikko.sysikaski@gmail.com>
 * This program is free software distributed under GNU General Public License
 * version 3 or (at your option) any later version.
 * No warranty of any kind is provided. See the accompanying file COPYING for details.
 */

#ifndef RENDERER_H
#define RENDERER_H

#include <GL/gl.h>

struct SDL_Surface;
class Board;
class Physics;

const int BALL_LIST = 2;

class Renderer {
public:
	Renderer();
	~Renderer();
	
	void setBoard(Board* b, Physics* p);
	
	void render();
	
	void moveCamera(float ydiff) {
		m_height += ydiff;
		if (m_height < 0)
			m_height = 0;
	}
	void init();
	void resetGL();

	bool topView;
	bool turnBoard;
	
private:
	Board* m_board;
	Physics* m_state;
	
	float m_height;

	void genTextures();
	void reloadTextures();

	GLubyte* m_baseTex;
	GLubyte* m_blockTex;
};

#endif
