#include <cctype>
#include "mazesetter.h"
#include "menubg.h"
#include "mazegen.h"
#include "lcd.h"
#include "gameloop.h"
#include "glscreen.h"
#include "sound.h"

MazeSetter::MazeSetter():
	m_starter(*this), m_wsize(10), m_hsize(10)
{
	m_generator = new MazeGen;
	
	m_algo.add("prim");
	m_algo.add("dfs");
	m_algo.add("kruskal");
	m_algo.add("chambers");

	items.push_back(Item("size w", &m_wsize));
	items.push_back(Item("size h", &m_hsize));
	items.push_back(Item("algorithm", &m_algo));
	items.push_back(Item("start", &m_starter));
}

void MazeSetter::draw()
{
	glLoadIdentity();
	MenuBG::draw();

	glScalef(0.1, 0.1, 0.1);
	glTranslatef(-8.5, 8.5, 0);

	glLineWidth(2);
	GLfloat hlColor[4] = {1,1,0,1};
	memcpy(menuitems::hlColor, hlColor, 4*sizeof(GLfloat));
	for(uint i=0; i<items.size(); ++i) {
		const char* const str = items[i].first.c_str();
		if (i == activeItem) {
			glColor3f(0, 1, 1);
			glLineWidth(4);
			LCD::print(str);
			glLineWidth(2);
		}
		glColor3f(0, 1, 0);
		LCD::print(str);

		glColor3f(1, 0, 0);
//		glSecondaryColor3f(1, 1, 0);
//		glPushMatrix();
		glTranslatef(6, 0, 0);
		items[i].second->draw();
		glTranslatef(-6, 0, 0);
//		glPopMatrix();
		glTranslatef(0, -1.4, 0);
	}
	
	SDL_GL_SwapBuffers();
}

bool MazeSetter::Starter::handleKey(SDLKey key)
{
	if (key==SDLK_RETURN || key==SDLK_SPACE) {
		int w=m_setter.m_wsize.getValue();
		int h=m_setter.m_hsize.getValue();
		if (w==0 || h==0)
			return 1;
		Board& b = m_setter.m_generator->genMaze(w, h, MazeGen::Algorithm(m_setter.m_algo.getActive()));
		GameLoop::init();
		GameLoop game(b);
		game.start();
		GameLoop::deInit();
	}
	return 1;
}
