/* Copyright (C) 2007  Mikko Sysikaski <mikko.sysikaski@gmail.com>
 * This program is free software distributed under GNU General Public License
 * version 3 or (at your option) any later version.
 * No warranty of any kind is provided. See the accompanying file COPYING for details.
 */
 
#include <GL/gl.h>
#include <cstdio>
#include <sstream>
#include <boost/lexical_cast.hpp>
#include "mainmenu.h"
#include "lcd.h"
#include "glscreen.h"
#include "dirdata.h"
#include "boardpicker.h"
#include "optionsmenu.h"
#include "packpicker.h"
#include "menubg.h"
#include "mazesetter.h"
#include "renderer.h"

//const GLuint TITLE_LIST = 4;

MainMenu::MainMenu()
{
	items.push_back("single boards");
	items.push_back("level packs");
	items.push_back("random maze");
	items.push_back("options");
	items.push_back("exit");

	GLScreen::set2D();

	DirData levs("levs");

	std::vector<std::string>& boardList = levs.getBoards();
	std::vector<std::string>& packList = levs.getPacks();
	m_boards = new BoardPicker(boardList.begin(), boardList.end(), packList.begin(), packList.end());
	m_packs = new PackPicker(packList.begin(), packList.end());
	m_maze = new MazeSetter;
	
	MenuBG::init();
	m_options = new OptionsMenu;
	
	glDisable(GL_TEXTURE_2D);
	glDisable(GL_LIGHTING);
	glDisable(GL_DEPTH_TEST);
}

void MainMenu::draw()
{
//	glClear(GL_COLOR_BUFFER_BIT);
	glLoadIdentity();
	
//	glCallList(TITLE_LIST);
	drawTitle();
	
//	glTranslatef(0.8, 0.5, 0);
	glTranslatef(0, -0.05, 0);
	glScalef(0.15, 0.15, 0.15);
	glEnable(GL_BLEND);
	glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
	glColor4f(0.6, 0.6, 0.6, 0.8);
	const float W = 4.0f;
	const float H = 7.4f;
	glBegin(GL_QUADS);
	glVertex2f(-W, -H+1.2f);
	glVertex2f(W, -H+1.2f);
	glVertex2f(W, 1.2f);
	glVertex2f(-W, 1.2f);
	glEnd();
	glDisable(GL_BLEND);
	
	glColor3f(0, 0, 1);
	for(ItemList::iterator i=items.begin(); i!=items.end(); ++i) {
		if (i-items.begin() == int(activeItem)) {
			glColor3f(0.3, 0.3, 1);
			glLineWidth(3);
			LCD::print(i->c_str(), LCD::MIDDLE);
			glColor3f(0, 0, 1);
			glLineWidth(1);
		}
		LCD::print(i->c_str(), LCD::MIDDLE);
		glTranslatef(0, -1.5, 0);
	}
	
	SDL_GL_SwapBuffers();
}

bool MainMenu::pick(int num)
{
	switch(num) {
		case 0:
			m_boards->exec();
			break;
		case 1:
			m_packs->exec();
			break;
		case 2:
			m_maze->exec();
			break;
		case 3:
			m_options->exec();
			break;
		default:
			return 0;
	}
	return 1;
}

inline
void MainMenu::drawTitle()
{
//	glNewList(TITLE_LIST, GL_COMPILE);
	MenuBG::draw();
	glPushMatrix(); {
		glTranslatef(-0.5, 0.5, 0);
		glScalef(0.3, 0.3, 0.3);
		glLineWidth(7);
		glColor3f(0, 0, 0);
		LCD::print("kuula");
		glLineWidth(5);
		glColor3f(0, 0, 1);
		LCD::print("kuula");
		glLineWidth(1);

		glTranslatef(-0.6, 0.5, 0);
		glScalef(0.5, 0.5*GLScreen::getResX()/GLScreen::getResY(), 0.5);
		glEnable(GL_LIGHTING);
		glCallList(BALL_LIST);
		glDisable(GL_LIGHTING);
	} glPopMatrix();
//	glEndList();
}
