/* Copyright (C) 2007  Mikko Sysikaski <mikko.sysikaski@gmail.com>
 * This program is free software distributed under GNU General Public License
 * version 3 or (at your option) any later version.
 * No warranty of any kind is provided. See the accompanying file COPYING for details.
 */

#ifndef DRAWUTILS_H
#define DRAWUTILS_H

#include <GL/gl.h>

namespace drawutils {
	void renderBall(int levels);
	void renderSphere(int edges, float rad=1.0f);

	inline void hQuad(float x1, float x2, float y1, float y2, float z)
	{
//	printf("Drawing hquad to %f %f %f %f %f\n", x1, x2, y1, y2, z);
		glNormal3f(0, 0, x1 < x2 ? 1 : -1);
		glTexCoord2f(x1, y1); glVertex3f(x1, y1, z);
		glTexCoord2f(x2, y1); glVertex3f(x2, y1, z);
		glTexCoord2f(x2, y2); glVertex3f(x2, y2, z);
		glTexCoord2f(x1, y2); glVertex3f(x1, y2, z);
	}
	inline void vQuad(float x, float y1, float y2, float z1, float z2)
	{
		glNormal3f(z1 < z2 ? 1 : -1, 0, 0);
		glTexCoord2f(z1, y1); glVertex3f(x, y1, z1);
		glTexCoord2f(z1, y2); glVertex3f(x, y2, z1);
		glTexCoord2f(z2, y2); glVertex3f(x, y2, z2);
		glTexCoord2f(z2, y1); glVertex3f(x, y1, z2);
	}
	inline void hTopQuad(float x1, float x2, float y, float z1, float z2)
	{
		glNormal3f(0, 1, 0);
		glTexCoord2f(x1, z1); glVertex3f(x1, y, z1);
		glTexCoord2f(x2, z1); glVertex3f(x2, y, z1);
		glTexCoord2f(x2, z2); glVertex3f(x2, y, z2);
		glTexCoord2f(x1, z2); glVertex3f(x1, y, z2);
	}
	inline void vTopQuad(float x1, float x2, float y, float z1, float z2)
	{
		glNormal3f(0, 1, 0);
		glTexCoord2f(z1, x1); glVertex3f(x1, y, z1);
		glTexCoord2f(z1, x2); glVertex3f(x2, y, z1);
		glTexCoord2f(z2, x2); glVertex3f(x2, y, z2);
		glTexCoord2f(z2, x1); glVertex3f(x1, y, z2);
	}
	// NOTE: expects normal to be set by caller
	inline void diagQuad(float x1, float x2, float y1, float y2, float z1, float z2)
	{
		glTexCoord2f(x1, y1); glVertex3f(x1, y1, z1);
		glTexCoord2f(x2, y1); glVertex3f(x2, y1, z2);
		glTexCoord2f(x2, y2); glVertex3f(x2, y2, z2);
		glTexCoord2f(x1, y2); glVertex3f(x1, y2, z1);
	}
	inline void diagTopQuad(float x1, float x2, float y, float z1, float z2, float dx, float dz)
	{
		glNormal3f(0, 1, 0);
		glTexCoord2f(x1, -dz); glVertex3f(x1-dx, y, z1+dz);
		glTexCoord2f(x2, -dz); glVertex3f(x2-dx, y, z2+dz);
		glTexCoord2f(x2, dz); glVertex3f(x2+dx, y, z2-dz);
		glTexCoord2f(x1, dz); glVertex3f(x1+dx, y, z1-dz);
	}
}

#endif
