/* Copyright (C) 2007  Mikko Sysikaski <mikko.sysikaski@gmail.com>
 * This program is free software distributed under GNU General Public License
 * version 3 or (at your option) any later version.
 * No warranty of any kind is provided. See the accompanying file COPYING for details.
 */

#include "dirdata.h"
#include <boost/filesystem/convenience.hpp>
#include <stdio.h>
#include <algorithm>

namespace fs = boost::filesystem;

DirData::DirData(const std::string& levelDir)
{
	scanDir(levelDir);
}

void DirData::scanDir(const std::string& levelDir)
{
	fs::path dir(levelDir);
	fs::directory_iterator end;
	for(fs::directory_iterator i(dir); i != end; ++i) {
		if (i->leaf()[0] == '.')
			continue;	// exclude hidden directories
		if (fs::is_directory(*i))
			m_packs.push_back(i->leaf());
		else
			m_boards.push_back(i->leaf());
	}
	std::sort(m_packs.begin(), m_packs.end());
	std::sort(m_boards.begin(), m_boards.end());
}
