/* Copyright (C) 2007  Mikko Sysikaski <mikko.sysikaski@gmail.com>
 * This program is free software distributed under GNU General Public License
 * version 3 or (at your option) any later version.
 * No warranty of any kind is provided. See the accompanying file COPYING for details.
 */

#ifndef BOARD_H
#define BOARD_H

#include <istream>
#include <vector>
#include "common.h"

enum BlockT {
	EMPTY,
	START,
	END,
	HOLE,
	SHOLE
};

class Board {
public:
	Board();
	Board(const char* filename);
	~Board();
	
	void load(const char* filename);
	
	const Coord2& startPlace() const {
		return m_startPlace;
	}
	BlockT getBlock(int y, int x) const {
		return m_blocks[y*m_x + x];
	}
	const char* operator[](int index) const {
		return m_board + m_x*index;
	}
	int getX() const {
		return m_x;
	}
	int getY() const {
		return m_y;
	}
	bool loaded() const {
		return static_cast<bool>(m_board);
	}
	int getMinTime() const {
		return m_minTime;
	}
	bool noTopView() const  {
		return m_noTopView;
	}

protected:
	char* m_board;
	BlockT* m_blocks;
	int m_x, m_y;
	int m_minTime;
	
	Coord2 m_startPlace;
	
	bool m_noTopView;

private:
	void clear();
	
	// non copy-constructable currently
	Board(const Board&) {}
};

#endif
