float4x4 g_mWorldViewProj;
float4x4 g_mWorldView;
float4x4 g_mWorld;

float4x4 g_mIsoCheckInvTransform;

texture g_tEnvMap;
texture g_tTex;

texture g_tVolumeMap;

sampler SamplerEnv = sampler_state {
    Texture   = (g_tEnvMap);
    MipFilter = LINEAR;
    MinFilter = LINEAR;
    MagFilter = LINEAR;
};

sampler Sampler = sampler_state {
    Texture   = (g_tTex);
    MipFilter = LINEAR;
    MinFilter = LINEAR;
    MagFilter = LINEAR;
};

float3 g_f3LightDir=float3(0, 0, -1);
	
float4 g_f4DiffuseColour=float4(0.4, 0.4, 0.4, 1.0);

void IsoVS(		float4 Position : POSITION, float3 Normal : NORMAL,  float2 UV : TEXCOORD0,
					out float4 oPosition : POSITION, out float4 oCol : COLOR0, out float3 oIso : TEXCOORD0, out float2 oUVEnv : TEXCOORD1, out float2 oUV : TEXCOORD2)
{
	oPosition=mul(Position, g_mWorldViewProj);
	oIso=mul(Position, g_mIsoCheckInvTransform);
	
	float3 n=normalize(mul(Normal, (float3x3)g_mWorldView));

	oCol=dot(n, g_f3LightDir)*g_f4DiffuseColour;
	oUVEnv=float2(n.x+1, n.y+1)*0.5;
	oUV=UV;
}

void IsoVSInv(		float4 Position : POSITION, float3 Normal : NORMAL,  float2 UV : TEXCOORD0,
					out float4 oPosition : POSITION, out float4 oCol : COLOR0, out float3 oIso : TEXCOORD0, out float2 oUVEnv : TEXCOORD1, out float2 oUV : TEXCOORD2) 
{
	oPosition=mul(Position, g_mWorldViewProj);
	oIso=mul(Position, g_mIsoCheckInvTransform);
	
	float3 n=normalize(mul(-Normal, (float3x3)g_mWorldView));
	
	oCol=dot(n, g_f3LightDir)*g_f4DiffuseColour;
	oUVEnv=float2(n.x+1, n.y+1)*0.5;
	oUV=UV;
}


float TangleFunction(float3 iso)
{
	return pow(iso.x, 4) - 5.f*iso.x*iso.x + pow(iso.y, 4) - 5*iso.y*iso.y + pow(iso.z, 4) - 5*iso.z*iso.z + 11.85;
}

float4 OutsideTanglePS(float3 iso : TEXCOORD0, float2 UVEnv : TEXCOORD1, float2 UV : TEXCOORD2, float4 col : COLOR0) : COLOR
{
	clip(TangleFunction(iso));
//	return tex2D(SamplerEnv, UVEnv)*1.25+col;
	return tex2D(SamplerEnv, UVEnv)*tex2D(Sampler, UV)+col;
//	return col*tex2D(SamplerEnv, UVEnv);
}

float4 InsideTanglePS(float3 iso : TEXCOORD0, float2 UVEnv : TEXCOORD1, float2 UV : TEXCOORD2, float4 col : COLOR0) : COLOR
{
	clip(-TangleFunction(iso));
//	return tex2D(Sampler, UVEnv)*1.25*0+col;//*0.75;
//	return tex2D(SamplerEnv, UVEnv)+tex2D(Sampler, UV);
	return col+tex2D(SamplerEnv, UVEnv)*0.5;
}

technique OutsideTangle {
	pass P0 {
		VertexShader = compile vs_1_1 IsoVS();
		PixelShader = compile ps_2_0 OutsideTanglePS();
	}
}

technique InsideTangle {
	pass P0 {
		CullMode = CW;
		VertexShader = compile vs_1_1 IsoVSInv();
		PixelShader = compile ps_2_0 InsideTanglePS();
	}
}