texture g_tTex;

sampler Sampler = sampler_state {
    Texture   = (g_tTex);

    AddressU=Wrap;
    AddressV=Wrap;

    MipFilter = Linear;
    MinFilter = Linear;
    MagFilter = Linear;
};

static const int kernelsize=13;

float4 HTexelKernel[kernelsize];
float4 VTexelKernel[kernelsize];

static const float r=1.f/4096.f;
static const float TexelWeights[kernelsize]={ 1*r, 12*r, 66*r, 220*r, 495*r, 792*r, 924*r, 796*r, 495*r, 230*r, 66*r, 12*r, 1*r};

//static const float r=1.f/16384.f;
//static const float TexelWeights[kernelsize]={ 14*r, 91*r, 364*r, 1001*r, 2002*r, 3003*r, 3432*r, 3003*r, 2002*r, 1001*r, 364*r, 91*r, 14*r};


float4 HorizBlurPS(float2 UV : TEXCOORD0) : COLOR
{
	float4 col=float4(0, 0, 0, 0);
	
	for(int i=0; i<kernelsize; i++)
		col+=tex2D(Sampler, UV+HTexelKernel[i].xy)*TexelWeights[i];
		
	//return col/kernelsize;
	return col;
}

float4 VertBlurPS(float2 UV : TEXCOORD0) : COLOR
{
	float4 col=float4(0, 0, 0, 0);
	
	for(int i=0; i<kernelsize; i++)
		col+=tex2D(Sampler, UV+VTexelKernel[i].xy)*TexelWeights[i];
		
	//return col/kernelsize;
	return col;
}

float g_fBrightThreshold;

float4 BrightPassPS(float2 UV : TEXCOORD0) : COLOR
{
	float4 col=tex2D(Sampler, UV);
	
	if((col.x<g_fBrightThreshold) && (col.y<g_fBrightThreshold) && (col.z<g_fBrightThreshold))
		clip(-1);
		
	return max(float4(0, 0, 0, 0), (col-g_fBrightThreshold)*(1.f/(1-g_fBrightThreshold)));
	//return col;
}

float g_fCrashMul;

float4 CrashZoomPS(float2 UV : TEXCOORD0) : COLOR
{
	return tex2D(Sampler, UV)*g_fCrashMul;
}

technique BlurHoriz {
	pass P0 {
		CullMode=none;
		ZEnable=false;
		ZWriteEnable=false;
		
		VertexShader = null;
		PixelShader = compile ps_2_0 HorizBlurPS();
	}
}

technique BlurVert {
	pass P0 {
		CullMode=none;
		ZEnable=false;
		ZWriteEnable=false;
		
		VertexShader = null;
		PixelShader = compile ps_2_0 VertBlurPS();
	}
}

technique BrightPass {
	pass P0 {
		CullMode=none;
		ZEnable=false;
		ZWriteEnable=false;
		
		VertexShader = null;
		PixelShader = compile ps_2_0 BrightPassPS();
	}
}

technique CrashZoom {
	pass P0 {
		CullMode=none;
		ZEnable=false;
		ZWriteEnable=false;
		
		AlphaBlendEnable=true;
		SrcBlend=One;
		DestBlend=One;
		
		VertexShader=null;
		PixelShader = compile ps_2_0 CrashZoomPS();
	}
}