uniform float distortionAngle;
uniform float distortionRadius;

uniform float xTrap;
uniform float yTrap;

uniform float textureScale;
uniform float textureAngle;
uniform sampler2D image;

void main()
{
	// ----------------------------- Boogiebrot iteration initialization start ---
	const int maxIter = 45;
	const float bailout = 1.0e4;
	int numIter = 0;

	// Initial position
	vec2 z = gl_TexCoord[0].xy, zPrevious;
	vec2 pixel = z;
	
	// Bailout flag
	bool isInside = true;
	float distance;
	
	float xDistortion = distortionRadius * cos(distortionAngle);
	float yDistortion = distortionRadius * sin(distortionAngle);
	
	// ----------------------------- Boogiebrot iteration initialization end -----

	const int trapIter = 2;
	vec2 zTrapped = z;
	
	float minDistance = 1.0e5;
	
	// Iterate
	while ((isInside) && (numIter < maxIter))
	{
		// ------------------------- Boogiebrot iteration start -----
		float A = z.x*z.x - z.y*z.y;
		float B = 2.0*z.x*z.y;
		float C = 1.0 + z.x*xDistortion - z.y*yDistortion;
		float D = z.x*yDistortion + z.y*xDistortion;
		
		// Nominator vector
		vec2 AB = vec2(A, B);
		// Denominator vector
		vec2 CD = vec2(C, D);

		// Iterate the formula z(n+1) = z(n)^2 / (1 + d*z) + C
		z = vec2(dot(AB, CD), B*C - A*D) / (dot(CD,CD)) + pixel;
		
		distance = length(z);

		// Test bailout
		isInside = (distance > bailout) ? false : true;
		
		// Next iteration		
		numIter++;
		// ------------------------- Boogiebrot iteration end -------

		// Get trapped iterate
		zTrapped = (numIter == trapIter) ? z : zTrapped;
	}

	if (isInside)
	{
		gl_FragColor = vec4(0.55, 0.03, 0.35, 1.0);
		return;
	}

	// Rotate texture position
	float rotSin = sin(textureAngle), rotCos = cos(textureAngle);
	
	vec2 position = textureScale * zTrapped + vec2(xTrap, yTrap);
	
	vec2 rotatedPosition = vec2(position.x*rotCos - position.y*rotSin,
							position.x*rotSin + position.y*rotCos);
	
	gl_FragColor = texture2D(image, rotatedPosition);
}

