#include "prewx.h"
#include "dollar.h"
#include "sprite.h"
#include "hovedvindu.h"
#include "konstanter.h"
#include <math.h>

BEGIN_EVENT_TABLE(Hovedvindu, wxFrame)
	EVT_MENU (uID_Ny, Hovedvindu::ID_Ny)
	EVT_MENU (uID_Last, Hovedvindu::ID_Last)
	EVT_MENU (uID_Avslutt, Hovedvindu::ID_Avslutt)
	EVT_MENU (uID_Hjelp, Hovedvindu::ID_Hjelp)
	EVT_MENU (uID_About, Hovedvindu::ID_About)
	EVT_MENU (uID_Highscore, Hovedvindu::ID_Highscore)
	EVT_TIMER(uID_Timer, Hovedvindu::OnTimer)
END_EVENT_TABLE()

Hovedvindu::Hovedvindu(const wxString &tittel, const wxPoint &pos, const wxSize &storrelse, wxString filnavner, long nummerer) 
						:wxFrame((wxFrame *) NULL, -1, tittel, pos, storrelse)
{
	levelLastet = false;
	arkiv = NULL;
	spiller = NULL;
	spiller2 = NULL;
	level = NULL;
	backBuffer = NULL;
	finalBackBuffer = NULL;
	highscorelevel = "";
	wxMenuBar *meny = new wxMenuBar;
	multi = false;
	totaltdrept = 0;
	score = 0;
	time ( &rawtime );
	timeinfo = localtime ( &rawtime );
	antiTestHighScore = 0;
	beat = false;
	once = true;
	//loadtime = 0;
	urort = "";
	
	
	wxMenu *menuStart = new wxMenu;

	/*menuStart->Append(uID_Ny, _T("&New Game"));
	menuStart->AppendSeparator();*/
	menuStart->Append(uID_Last, _T("&Load Game"));
	menuStart->AppendSeparator();
	menuStart->Append(uID_Avslutt, _T("&Exit"));

	wxMenu *menuHjelp = new wxMenu;

	menuHjelp->Append(uID_About, _T("&About"));

	wxMenu *menuControl = new wxMenu;

	menuControl->Append(uID_Highscore, _T("&Highscore"));
	//menuHjelp->AppendSeparator();
	//menuHjelp->Append(uID_About, _T("&About"));

	meny->Append(menuStart, _T("&Start"));
	meny->Append(menuHjelp, _T("&Help"));
	meny->Append(menuControl, _T("&Control"));

	SetMenuBar(meny);

	pa_hoved = new wxPanel(this, -1);

	pa_tekst = new wxPanel(pa_hoved, -1, wxDefaultPosition, wxSize(200, 200), wxBORDER_STATIC);

	spillvindu = new wxWindow(pa_hoved, -1, wxDefaultPosition, wxSize(200,200), wxBORDER_STATIC);
	spillvindu->Connect(-1, -1, wxEVT_PAINT,
		(wxObjectEventFunction) &Hovedvindu::OnPaint, NULL, this);
	spillvindu->Connect(-1, -1, wxEVT_KEY_DOWN,
		(wxObjectEventFunction) &Hovedvindu::OnKey, NULL, this);
    spillvindu->Connect(-1, -1, wxEVT_SIZE,
		(wxObjectEventFunction) &Hovedvindu::OnSize, NULL, this);

	st_spillerliv = new wxStaticText(pa_tekst, -1, _T("Lives left [1]:"), wxDefaultPosition, wxSize(100,20), wxST_NO_AUTORESIZE);
	st_spillerliv2 = new wxStaticText(pa_tekst, -1, _T("Lives left [2]:"), wxDefaultPosition, wxSize(100,20), wxST_NO_AUTORESIZE);
	st_fiender = new wxStaticText(pa_tekst, -1, _T("Enemies left:"), wxDefaultPosition, wxSize(100,20), wxST_NO_AUTORESIZE);
	st_level = new wxStaticText(pa_tekst, -1, _T("Level:"), wxDefaultPosition, wxSize(100,20), wxST_NO_AUTORESIZE);
    //st_speed = new wxStaticText(pa_tekst, -1, _T("Score:"), wxDefaultPosition, wxSize(100,20), wxST_NO_AUTORESIZE);
	wxBoxSizer *boxsizer = new wxBoxSizer(wxVERTICAL );

	boxsizer->Add(spillvindu, 1, wxGROW|wxALL,5);
	boxsizer->Add(pa_tekst, 0, wxGROW|wxALL|wxSTRETCH_NOT,5);

	wxBoxSizer *pa_tekst_sizer = new wxBoxSizer(wxHORIZONTAL);

	pa_tekst_sizer->Add(st_spillerliv,0,wxTOP,5);
	pa_tekst_sizer->Add(st_spillerliv2,0,wxTOP,5);
	pa_tekst_sizer->Add(st_fiender,0,wxTOP,5);
	pa_tekst_sizer->Add(st_level,0,wxTOP,5);
	//pa_tekst_sizer->Add(st_speed,0,wxTOP,5);

	pa_hoved->SetAutoLayout(TRUE);
	pa_hoved->SetSizer(boxsizer);

	pa_tekst->SetAutoLayout(TRUE);
	pa_tekst->SetSizer(pa_tekst_sizer);
	srand(wxGetElapsedTime(false));
	wxStartTimer();
	



	draw.lagBakgrunnsBilde(BLOCK_EMPTY, &wxBITMAP(IMG_EMPTY));
	draw.lagBakgrunnsBilde(BLOCK_FULL, &wxBITMAP(IMG_VEGG));
	
	wxImage Image_spiller = wxBITMAP(IMG_SPILLER).ConvertToImage();
	Image_spiller.SetMaskColour(255,255,255);
	//Image_spiller.Replace(255,255,255,0,0,0);
	//wxBitmap Bitmap_spiller = wxBitmap(Image_spiller);
	//Image_spiller.Replace(255,255,255,0,0,0);
	//wxBitmap Bitmap_spillerdo = wxBitmap(Image_spiller);

	//wxImage sec_spiller = wxBitmap(sprites[TOOL_SPILLER]).ConvertToImage();
	//sec_spiller.SetMaskColour(255,255,255);
	Image_spiller.Replace(153,255,0,153,0,255);
	Image_spiller.Replace(0,153,0,0,0,153);
	Image_spiller.Replace(0,72,0,0,0,102);
	//wxBitmap Bitmap_spillernd = wxBitmap(Image_spiller);
	//Image_spiller.Replace(255,255,255,0,0,0);
	//draw.createSprite(SPRITE_PLAYER, &wxBitmap(Image_spiller));

	draw.createSprite(SPRITE_PLAYER, &wxBITMAP(IMG_SPILLER));
	draw.createSprite(SPRITE_ENEMY, &wxBITMAP(IMG_FIENDE));
	draw.createSprite(SPRITE_VAPEN, &wxBITMAP(IMG_BALL));
	draw.createSprite(4,&wxBitmap(Image_spiller));



	m_timer = new wxTimer(this, uID_Timer);
	gamestate = STATE_NULL;

	m_timer->Start(OPPDATERING);

	if(filnavner != "")
	{
		
		//wxString levelerrsora = _T("Input \n") + wxString::Format(_T("%d"),nummerer) + _T("\n") + wxString::Format(_T("%s"),filnavner);
		//wxMessageBox(levelerrsora,_T("Feil ved laging av ny level!"),wxICON_ERROR);
		/*if(nummerer == 1 && filnavner == "temp.sgc")
		{
		wxMessageBox(_T("wtf"),_T("Feil ved laging av ny level!"),wxICON_ERROR);
		}*/
		Do_Load(filnavner, (int)nummerer);
		///wxString levelerrsora = _T("Input \n") + wxString::Format(_T("%d"),nummerer) + _T("\n") + wxString::Format(_T("%s"),filnavner);
		//wxMessageBox(_T("!!!!:..."),_T("Feil ved laging av ny level!"),wxICON_ERROR);
	}

	


}

Hovedvindu::~Hovedvindu(void)
{
	gamestate = STATE_NULL;

	m_timer->Stop();

	delete m_timer;

	if(spiller)
		delete spiller;

	if(spiller2)
		delete spiller2;


	if(level)
		delete level;
	if(backBuffer)
	{
		delete backBuffer;
	}
	if(finalBackBuffer)
	{
		delete finalBackBuffer;
	}
}

void Hovedvindu::ID_Ny(wxCommandEvent &event)
{
	m_timer->Stop();

	if(spiller)
	{
		delete spiller;
		
	}
	if(spiller2)
	{
		delete spiller2;
	}
	//Sprite *a = new Sprite(level, &draw, SPRITE_VAPEN);
	levelLastet = false;
	spiller = new Helt(NULL, &draw,SPRITE_PLAYER);
	//spillernd = new Helt(level,&draw,0,5,5,5,'8','4','6','5','0');
	startNyLevel(TYPE_RANDOM);
	
	ANTALL_FIENDER = 2;
	level->lagFiende(ANTALL_FIENDER,5);
	currentLevel = 1;
	gamestate = STATE_ON;

	m_timer->Start(OPPDATERING);



}

void Hovedvindu::ID_Last(wxCommandEvent &event)
{
	score = 0;
	time ( &rawtime );
	timeinfo = localtime ( &rawtime );
	antiTestHighScore = 0;
	beat = false;
	highscorelevel = "";
	wxFileDialog hent(this, _T("Hent fil"), _T(""), _T(""), _T("Level (*.sgc)|*.sgc"),0);
	antiTestHighScore = 2;

	if(hent.ShowModal() == wxID_OK)
	{
		urort = hent.GetFilename().c_str();
		highscorelevel = hent.GetFilename().c_str();
		highscorelevel.Replace(".sgc",".hsl");
		Do_Load(hent.GetPath().c_str(),1);
	}
}

void Hovedvindu::ID_Avslutt(wxCommandEvent &event)
{
	Close(TRUE);
}


void Hovedvindu::ID_Hjelp(wxCommandEvent &event)
{
}

void Hovedvindu::ID_About(wxCommandEvent &event)
{
	wxMessageBox(_T("Gamedev compo bidrag av Racin W. Nygaard"),_T("About"));
}

void Hovedvindu::OnPaint(wxPaintEvent &event)
{
	wxPaintDC dc(spillvindu);

	dc.SetBackground(*wxBLACK_BRUSH);
	dc.Clear();

	updateDraw();
}

void Hovedvindu::OnTimer(wxTimerEvent &event)
{
	if(gamestate == STATE_ON)
	{
		updateGame();
		/*Timerlol++;
		if(Timerlol > 5)
			Timerlol = 0;*/
	}
}

void Hovedvindu::OnKey(wxKeyEvent &event)
{
	
//	if(level->getAntallSpillere() >= 1)
//	{
	if(gamestate == STATE_ON)
	{
		level->keyPress(event.GetKeyCode() | 32);
	}
//	}

	//updateDraw();
}

bool Hovedvindu::startNyLevel(LevelType typeer)
{
	int playercount = 0;
	int playercountnd = 0;
	score = 0;
	//multi = false;

	// IKKE FJERN DETTE, skaper problemer med  bytte level (Ja, snakker av erfaring :-P)
	/*if(level)
	{
		delete level;
		level = 0;	
	}*/
	
	switch (typeer)
	{
		case TYPE_RANDOM:
		{
		level = new Level(&draw, LEVEL_X, LEVEL_Y);
		break;
		}
		

		case TYPE_LOAD:
		{
			Arkiv::iterator iter;

			int l = 0;
			

			if(currentLevel > (int)arkiv->size())
			{
				//wxMessageBox(_T("currentlevel er over arkivet"),_T(",,,,,"));
				return true;
			}

			for(iter = arkiv->begin(); iter != arkiv->end(); iter++, l++)
			{
				//wxMessageBox(_T("..ss.."),_T(",,,,,"));
				if(l == currentLevel - 1)
				{
					//wxMessageBox(_T("RIKTIG LEVEL"),_T(",,,,,"));
					map *ny_level = *iter;


					level = new Level(&draw, ny_level->levelxy, ny_level->x, ny_level->y);
					//wxMessageBox(_T("level pointer done"),_T(",,,,,"));
					
					//break;

					//levelnd = new Level(&draw,ny_level->levelxy,ny_level->x,ny_level->y);
					//wxMessageBox(_T("lol"),_T("Feil ved laging av ny level!"),wxICON_ERROR);
					//iter = arkiv->end();
					/*for(int x = 0; x < ny_level->x; x++)
					{
						for(int y = 0; y < ny_level->y; y++)
						{
							if(ny_level->levelxy[x][y] == TOOL_SPILLER)
							{
								playercount++;
							}
							if(ny_level->levelxy[x][y] == 4)
							{
								playercountnd++;
							}
						}
					}
					//spiller->multi = true;
					if(playercountnd >= 1)
					{
						wxMessageBox(_T("6.1asdss"),_T("About"));
					}*/
					if(level->getAntallSpillere() >= 2)
					{
						multi = true;
					}
					else
					{
						multi = false;
					}
					//wxMessageBox(_T("end"),_T(",,,,,"));
					//multi = true;

				}
			}
		}
		/*break;
		default:
			wxString levelerror = _T("Du prvde  lage en level med: ") + wxString::Format(_T("%d"), typeer) + _T("\nDen eksisterer ikke!");
			wxMessageBox(levelerror,_T("Feil ved laging av ny level!"),wxICON_ERROR);
		break;*/
	};
	//Level *level = new Level(&draw, LEVEL_X, LEVEL_Y);
	//Level *level = new Level(&draw, LEVEL_X, LEVEL_Y);
	if(backBuffer)
	{
		delete backBuffer;
		backBuffer = 0; 
	}
	backBuffer = new wxBitmap((level->getWidth()) * IMG_SIZE, (level->getHeight()) * IMG_SIZE);
	//strekkBilde = backBuffer->ConvertToImage();
	draw.SetVindu(backBuffer, level->getWidth(), level->getHeight());
	//wxMessageBox(_T("Backbuffer lager, og vinduet peker til den."),_T(",,,,,"));
	
	if(multi)
	{
		//wxMessageBox(_T("6.1"),_T("About"));
		//spiller = new Helt(NULL, &draw, 0);
		//spillernd = new Helt(NULL, &draw, 0);
		//level->nySpiller(spillernd);
		level->setantallspillere(2);
		level->nySpiller(spiller,1);
		level->nySpiller(spiller2,2);

		level->draw();
		//levelnd->draw();

		
		spiller2->setLevel(level);
		spiller->setLevel(level);
		spiller2->update();
		spiller->update();
		//wxMessageBox(_T("Ferdig i Startlevel. [mp]"),_T(",,,,,"));
		//multi = false;
	}
	else 
	{	
		/*if(typeer != TYPE_RANDOM)
		{
			if(spiller2->isAlive())
			{
			
				spiller2->addLives(-5);		
			}
		}*/
		level->setantallspillere(1);
		//spiller = new Helt(NULL, &draw, 0);

		level->nySpiller(spiller,1);
		//level->nySpiller(spillernd);
		level->draw();

	//	spillernd->setLevel(level);
	//	spillernd-> update();
		spiller->setLevel(level);
		spiller->update();
		//wxMessageBox(_T("Ferdig i Startlevel. [sp]"),_T(",,,,,"));
		
	}
//	updateGame();
//	updateDraw();
	return false; 
}

void Hovedvindu::updateDraw(void)
{
	wxClientDC omrade(spillvindu);
	//wxMessageBox(_T("6.1"),_T("About"));
	//omrade.DrawBitmap(*finalBackBuffer,wxPoint(0,0));
	//wxSize gameWindow = spillvindu->GetClientSize();
	//finalBackBuffer = new wxBitmap(gameWindow.GetWidth(), gameWindow.GetHeight());
	if(gamestate == STATE_ON)
	{
		//wxMessageBox(_T("6.1"),_T("About"));
		strekkVindu();
		//wxMessageBox(_T("6.2"),_T("About"));
	}	
		//omrade.DrawBitmap(*finalBackBuffer,wxPoint(0,0));
	else
		drawInfo();

	//wxMessageBox(_T("6.3"),_T("About"));
	flipBackBuffer();
	//wxMessageBox(_T("6.4"),_T("About"));

	
}

void Hovedvindu::updateGame(void)
{	
	//score = ((totaltdrept*100000)/wxGetElapsedTime(false));
	wxString info_spillerliv = _T("Liv igjen [1]: ") + wxString::Format(_T("%d"), spiller->getLives());
	wxString info_spillerliv2 = _T("Liv igjen [2]: ") + wxString::Format(_T("%d"), spiller2->getLives());
	wxString info_fiender = _T("Fiender igjen: ") + wxString::Format(_T("%d"), level->numEnemies());
	wxString info_level = _T("Level: ") + wxString::Format(_T("%d"), currentLevel);
	wxString info_speed = _T("Score: ") + wxString::Format(_T("%d"), score);

	st_spillerliv->SetLabel(info_spillerliv);
	if(level->getAntallSpillere() == 2)
	{
	st_spillerliv2->SetLabel(info_spillerliv2);
	}
	st_fiender->SetLabel(info_fiender);
	st_level->SetLabel(info_level);
	//st_speed->SetLabel(info_speed);
	
	if(level->numEnemies() == 0)
	{
		//setTotalfienderdrept(level->numEnemies());
		m_timer->Stop();
		currentLevel++;
		//wxMessageBox(_T("INKREMENTERT!"),_T("HEIll"));
		if(levelLastet == true)
		{
			
			if(startNyLevel(TYPE_LOAD))
			{
				levelLastet = false;

				gamestate = STATE_WIN;
				//setTotalfienderdrept(level->numEnemies());
				//level->setantallspillere(0);
				updateDraw();
				//wxMessageBox(_T("HEIs"),_T("HEIll"));
				return;
			}
			
			//wxMessageBox(_T("Antallspillere satt til en."),_T("HEIll"));
			level->lagFiende(0);
			setTotalfienderdrept(level->numEnemies());
			//wxMessageBox(_T("Laget like mange fiender som det er i levelen."),_T("HEIll"));
			level->settSpillerReset(1);
			//wxMessageBox(_T("Stiller Spiller 1 tilbake til starten."),_T("HEIll"));
			
			if(multi)
			{
				//level->setantallspillere(2);
				level->settSpillerReset(2);
				//wxMessageBox(_T("Stiller spiller 2 tilbake til starten."),_T("HEIll"));
			}
			else
			{
				level->setantallspillere(1);
			}
			
		}

		else
		{
			startNyLevel(TYPE_RANDOM);

			ANTALL_FIENDER = currentLevel * 2;

			if(ANTALL_FIENDER > 15)
				ANTALL_FIENDER = 15;
			enemy_speed = 10*currentLevel;
			level->lagFiende(ANTALL_FIENDER,enemy_speed);

			level->settSpillerReset(1);
		}

		m_timer->Start(OPPDATERING);
	}


	else if(level->numEnemies() > 0 && !spiller->isAlive())
	{
		if(level->getAntallSpillere() >= 2)
		{
			if(!spiller2->isAlive())
			{
				levelLastet = false;
				gamestate = STATE_OVER;
				m_timer->Stop();
				//wxMessageBox(_T("HEI555"),_T("HEIll"));
			}
		}
		else if(level->getAntallSpillere() < 2)
		{
			levelLastet = false;
			gamestate = STATE_OVER;
			m_timer->Stop();
		}
	}
	
	else
	{
		level->update(wxGetElapsedTime(false));
		//wxMessageBox(_T("HEI666"),_T("HEIll"));
	}

	updateDraw();
	
}

void Hovedvindu::flipBackBuffer(void)
{
	wxSize gameWindow = spillvindu->GetClientSize();
	wxMemoryDC finalDC;

	wxClientDC output(spillvindu);

	finalDC.SelectObject(*finalBackBuffer);

	output.Blit(wxPoint(0,0), gameWindow, &finalDC, wxPoint(0,0));

	finalDC.SelectObject(wxNullBitmap);
}

void Hovedvindu::OnSize(wxSizeEvent &event)
{
	event.Skip();

	if(finalBackBuffer)
	{
		delete finalBackBuffer;
	}
	wxSize gameWindow = spillvindu->GetClientSize();

	finalBackBuffer = new wxBitmap(gameWindow.GetWidth(), gameWindow.GetHeight());

	updateDraw();
	
	//strekkVindu();
	//flipBackBuffer();
	
}

void Hovedvindu::strekkVindu(void)
{
	wxSize gameWindow = spillvindu->GetClientSize();

	wxSize strekkStorrelse;

	if(gameWindow.GetWidth() * level->getHeight() / level->getWidth() < gameWindow.GetHeight())
	{
		strekkStorrelse.Set(gameWindow.GetWidth(), gameWindow.GetWidth() * level->getHeight() / level->getWidth());
	}
	else
	{
		strekkStorrelse.Set(gameWindow.GetHeight() * level->getWidth() / level->getHeight(), gameWindow.GetHeight());
	}

	strekkBilde = backBuffer->ConvertToImage();
	strekkBilde = strekkBilde.Scale(strekkStorrelse.GetWidth(),strekkStorrelse.GetHeight());
	wxMemoryDC finalDC;
	wxMemoryDC bildeDC;

	finalDC.SelectObject(*finalBackBuffer);
	bildeDC.SelectObject(strekkBilde);


	finalDC.SetBackground(*wxBLACK_BRUSH);
	finalDC.Clear();

	wxPoint midt;

	midt.x  = (gameWindow.GetWidth() - strekkStorrelse.GetWidth()) / 2;
	midt.y  = (gameWindow.GetHeight() - strekkStorrelse.GetHeight()) / 2;

	finalDC.Blit(midt, strekkStorrelse, &bildeDC, wxPoint(0,0));
	//finalDC.Blit(50,50,24,24,&bildeDC,0,0);
	finalDC.SetBrush(*wxTRANSPARENT_BRUSH);
	finalDC.DrawRectangle(wxPoint(0,0), gameWindow);
	//backBuffer = finalBackBuffer;

	bildeDC.SelectObject(wxNullBitmap);
	finalDC.SelectObject(wxNullBitmap);
}

	//}
	

	

	/* ---- CRAP ---- 
	else 
	{

		/*draw.lagBakgrunnsBilde(BLOCK_EMPTY, &wxBITMAP(IMG_EMPTY));
		draw.lagBakgrunnsBilde(BLOCK_FULL, &wxBITMAP(IMG_VEGG));

		draw.createSprite(SPRITE_PLAYER, &wxBITMAP(IMG_SPILLER));
		draw.createSprite(SPRITE_ENEMY, &wxBITMAP(IMG_FIENDE));
		draw.createSprite(SPRITE_VAPEN, &wxBITMAP(IMG_BALL));
		//backBuffer = new wxBitmap(strekkStorrelse.GetWidth(), strekkStorrelse.GetHeight());
	//strekkBilde = backBuffer->ConvertToImage();
	//	draw.SetVindu(finalBackBuffer, strekkStorrelse.GetWidth(), strekkStorrelse.GetHeight());
	if(backBuffer)
	{
		delete  backBuffer;
	}
/*	((strekkStorrelse.GetWidth())/(level->getWidth()))*(gameWindow.GetWidth/level->getWidth),
		(strekkStorrelse.GetHeight())/(level->getHeight()))
	//Level *level = new Level(&draw, LEVEL_X, LEVEL_Y);
	//Level *level = new Level(&draw, LEVEL_X, LEVEL_Y);
	backBuffer = new wxBitmap((level->getWidth()) * IMG_SIZE, (level->getHeight()) * IMG_SIZE);
	backBuffer = new wxBitmap(((strekkStorrelse.GetWidth()/level->getWidth()), 
		(strekkStorrelse.GetHeight()/level->getHeight()))));
	//strekkBilde = backBuffer->ConvertToImage();
	draw.SetVindu(backBuffer, (((strekkStorrelse.GetWidth())/(level->getWidth()))*((gameWindow.GetWidth())/(level->getWidth())), 
		((strekkStorrelse.GetHeight())/(level->getHeight()))*(gameWindow.GetHeight()/level->getHeight())))));

	level->nySpiller(spiller);
	level->draw();

	
	spiller->setLevel(level);
	spiller->update();
	wxClientDC omrade(spillvindu);
	omrade.DrawBitmap(*backBuffer,wxPoint(0,0));
		/*	wxSize gameWindow = spillvindu->GetClientSize();
		wxMemoryDC finalDC;

		wxClientDC output(spillvindu);

		finalDC.SelectObject(*finalBackBuffer);

		output.Blit(wxPoint(0,0), gameWindow, &finalDC, wxPoint(0,0));

		finalDC.SelectObject(wxNullBitmap);
		
	}
	//var = 0;
	//strekkBilde = strekkBilde.Rescale(150,150);
	//wxBitmap finalImage(strekkStorrelse.GetWidth(),strekkStorrelse.GetHeight());



	//updateGame();
/*	}
	else
	{ 
			finalDC.SelectObject(*finalBackBuffer);
				wxPoint midt;
				bildeDC.SelectObject(strekkBilde);

	midt.x  = (gameWindow.GetWidth() - strekkStorrelse.GetWidth()) / 2;
	midt.y  = (gameWindow.GetHeight() - strekkStorrelse.GetHeight()) / 2;
		finalDC.SetBackground(*wxBLACK_BRUSH);
	finalDC.Clear();
			
		finalDC.Blit(midt, strekkStorrelse, &bildeDC, wxPoint(0,0));
	}
	
	
	var = 0;

	---- Crap Done ---- */


void Hovedvindu::drawInfo(void)
{
	wxSize gameWindow = spillvindu->GetClientSize();

	wxMemoryDC finalDC;

	finalDC.SelectObject(*finalBackBuffer);

	finalDC.Clear();

	finalDC.DrawRectangle(0,0,gameWindow.GetWidth(),gameWindow.GetHeight());
	wxString message;
	if(gamestate == STATE_NULL)
	{		 
		message = _T("Welcome to Bug-hunter.   To control Player 1: A-S-W-D and SPACE,  Player 2: I-J-K-L and -   Thanks for playing! :-)");
	}

	else if(gamestate == STATE_WIN)
	{
		if (antiTestHighScore > 0)
		{
			//wxString levelerrsora = _T("Input \n") + wxString::Format(_T("%d"),levelnummerlocal) + _T("\n") + wxString::Format(_T("%s"),filnavna);
			//wxMessageBox(levelerrsora,_T("Feil ved laging av ny level!"),wxI
			if(score == 0)
			{
			score = ((totaltdrept*100000)/wxGetElapsedTime(false))*3;
			//message = _T("Gratulerer, du vant! :-) \n")  + wxString::Format(_T("%d"),((totaltdrept*100000)/wxGetElapsedTime(false)));// + _T("gfsxgf") + wxString::Format(_T("%d"),);
			//m_timer->Stop();
			//wxGetElapsedTime(true);
			LagreHighscore();
			//wxMessageBox(_T("tilbake"),_T("Feil ved laging av ny level!"));
			}
			//wxMessageBox(_T("open highscore"),_T("Feil ved laging av ny level!"));
			//OpenHighscore();
			//LagreHighscore();
			//OpenHighscore();
			if(beat)
			{
			message = _T("Gratulerer, du slo rekorden!!!!");//  + wxString::Format(_T("%d"),score) + _T(" ") + wxString::Format(_T("%s"),asctime(timeinfo));// + _T("gfsxgf") + wxString::Format(_T("%d"),);
			}
			else
			{
			message = _T("Du klarte ikke  sl rekorden.");//  + wxString::Format(_T("%d"),score) + _T(" ") + wxString::Format(_T("%s"),asctime(timeinfo));// + _T("gfsxgf") + wxString::Format(_T("%d"),);
			}
		}
		else
		{
			message = _T("Gratulerer, du vant! :-) \n");
		}
	}

	else if(gamestate == STATE_OVER)
	{	
		if (antiTestHighScore > 0)
		{
			if(score == 0)
			{
			score = ((totaltdrept*100000)/wxGetElapsedTime(false));
			//message = _T("Gratulerer, du vant! :-) \n")  + wxString::Format(_T("%d"),((totaltdrept*100000)/wxGetElapsedTime(false)));// + _T("gfsxgf") + wxString::Format(_T("%d"),);
			//m_timer->Stop();
			//wxGetElapsedTime(true);
			LagreHighscore();
			//wxMessageBox(_T("Ja.."),_T("jj"));
			}
			//score = 0;
			//OpenHighscore();
			if(beat)
			{
			message = _T("Game over. Du klarte  sl rekorden.");//  + wxString::Format(_T("%d"),score) + _T(" ") + wxString::Format(_T("%s"),asctime(timeinfo));// + _T("gfsxgf") + wxString::Format(_T("%d"),);
			}
			else
			{
			message = _T("Game over. Du klarte ikke  sl rekorden.");//  + wxString::Format(_T("%d"),score) + _T(" ") + wxString::Format(_T("%s"),asctime(timeinfo));// + _T("gfsxgf") + wxString::Format(_T("%d"),);
			}
			//message = _T("Game over\n") + wxString::Format(_T("%d"),score) + _T(" ") + wxString::Format(_T("%s"),asctime(timeinfo));
		}
		else
		{
			message = _T("Game over \n");
		}
	}


	int textbredde;
	int texthoyde;

	// SCORE:
	/*
	fiender drept / tid i desisekunder.
	score - highscorelevel
	Lagre fiender drept, tid, hvilken level. En fil for alle levler.
	*/
	finalDC.GetTextExtent(message, &textbredde, &texthoyde);

	wxPoint center((gameWindow.GetWidth() - textbredde) / 2, (gameWindow.GetHeight() - texthoyde) / 2);

	finalDC.DrawText(message, center);

	finalDC.SelectObject(wxNullBitmap);
	


}

void Hovedvindu::Do_Load(wxString filnavna, int levelnummerlocal)
{
	score = 0;
	/*if(level)
	{
		delete level;
		level = 0;	
	}*/
	int playercount = 0;
	int playercountnd = 0;
	//wxString levelerrsora = _T("Input \n") + wxString::Format(_T("%d"),levelnummerlocal) + _T("\n") + wxString::Format(_T("%s"),filnavna);
	//wxMessageBox(levelerrsora,_T("Feil ved laging av ny level!"),wxICON_ERROR);
	arkiv = new Arkiv();

	
	
	spiller = new Helt(NULL, &draw,SPRITE_PLAYER);
	spiller2 = new Helt(NULL,&draw,4,1,1,5,'i','j','l','k','-');

	FILE *hentfil;

	//const wxChar *filenavn = hentfil.GetPath().c_str();
	//highscorelevel = filnavna.
	hentfil = fopen(filnavna, "r+b");
	//highscorelevel = hentfil->GetFilename().c_str();
	//wxMessageBox(_T("1"),_T("About"));
	int antall; 
	fread(&antall,sizeof(int),1,hentfil);

	map *first;

	for(int i = 0; i < antall; i++)
	{
		map *MapLevel = new map;

		fread(&MapLevel->x, sizeof(int), 1, hentfil);
		fread(&MapLevel->y, sizeof(int), 1, hentfil);

		MapLevel->levelxy = new char *[MapLevel->x];
		
		for (int s = 0; s < MapLevel->x; s++)
		{
			MapLevel->levelxy[s] = new char[MapLevel->y];
			fread(MapLevel->levelxy[s], sizeof(char), MapLevel->y, hentfil);
		}

		arkiv->push_back(MapLevel);
		
		if(i == levelnummerlocal - 1) 
		{
			currentLevel = levelnummerlocal;
			first = MapLevel;
			//SetLevel(MapLevel);
		}
		
		if(first == MapLevel)
		{
			for(int x = 0; x < MapLevel->x; x++)
			{
				for(int y = 0; y < MapLevel->y; y++)
				{
					if(MapLevel->levelxy[x][y] == TOOL_SPILLER)
					{
						playercount++;
					}
					if(MapLevel->levelxy[x][y] == 4)
					{
						playercountnd++;
					}
				}
			}
			if(playercount >= 1 && playercountnd >= 1)
			{
				multi = true;
				//wxMessageBox(_T("HAHAHHAHAHAHAHHA"),_T("..."));
				//level->setantallspillere(2);
			}
			else
			{
				multi = false;
			}
		}
		
	}
	//wxMessageBox(_T("2"),_T("About"));
	fclose(hentfil);
	levelLastet = true;
	//wxMessageBox(_T("3"),_T("About"));
	startNyLevel(TYPE_LOAD);
	level->lagFiende(0);
	level->settSpillerReset(1);
	if(multi)
	{
		level->settSpillerReset(2);
	}
	setTotalfienderdrept(level->numEnemies());
	//wxMessageBox(_T("4"),_T("About"));
	currentLevel = levelnummerlocal;
	//level->settSpillerReset();
	gamestate = STATE_ON;
	//wxMessageBox(_T("5"),_T("About"));
	m_timer->Start(OPPDATERING);
	//wxMessageBox(_T("6"),_T("About"));
	//updateDraw();
	//wxMessageBox(_T("7"),_T("About"));
}

void Hovedvindu::setTotalfienderdrept(int antall)
{
	totaltdrept += antall;
}

void Hovedvindu::LagreHighscore(void)
{
	if(antiTestHighScore == 0)
	{
		return;
	}
	wxString nevermind;
	//beat = true;
	//int dotpos = highscorelevel.Find(".");
	//highscorelevel.Remove(dotpos);
	// const wxChar *filenavn = hent.GetPath().c_str();
	//highscorelevel.Replace(".sgc",".hsl");
	//const wxChar *filename = highscorelevel;
	//wxString hh = wxString::Format(_T("%d"),score) + _T(" ") + wxString::Format(_T("%s"),filename);
	//wxMessageBox(hh,_T("Highscore"),wxICON_INFORMATION);
	if(highscorelevel == "Level1.sgc" || highscorelevel == "Level2.sgc" || highscorelevel == "Level3.sgc")
	{
		FILE *readfile;
		
		//const wxChar *filenavn = hentfil.GetPath().c_str();
		//highscorelevel = filnavna.
		readfile = fopen(highscorelevel, "r+b");
		//wxMessageBox(_T("2"),_T("Highscore"),wxICON_INFORMATION);
		fread(&tidligere,sizeof(int),1,readfile);
		fread(&nevermind,sizeof(int),1,readfile);
		//fread(&merkelig,sizeof(int),1,readfile);
		//wxMessageBox(_T("3"),_T("Highscore"),wxICON_INFORMATION);
		fclose(readfile);
	}
	//wxMessageBox(_T("4"),_T("Highscore"),wxICON_INFORMATION);
	if(tidligere >= score)
	{
		//wxString hh = wxString::Format(_T("%d"),score) + _T(" ") + wxString::Format(_T("%d"),tidligere);
		//wxMessageBox(hh,_T("Highscore"),wxICON_INFORMATION);
		beat = false;
		//delete filename;
		//fclose(readfile);
		return;
	}
	//if(tidligere < score)
	//{
	//wxMessageBox(_T("hm2"),_T("Highscore"),wxICON_INFORMATION);
	//const wxChar *filename2 = filename.c_str();*/
	//wxString var = highscorelevel;
	//var.Replace(".sgc",".hsl");
	//const wxChar *filename = highscorelevel;
	FILE *fil;

	//const wxChar *filenavn = hentfil.GetPath().c_str();
	//highscorelevel = filnavna.
	beat = true;
	fil = fopen(highscorelevel,"w+b");
	//score - highscorelevel
	fwrite(&score, sizeof(int), 1, fil);
	fwrite(&highscorelevel,sizeof(wxString),1,fil);
	/*time ( &rawtime );
	timeinfo = localtime ( &rawtime );*/
	fwrite(&timeinfo,sizeof(tm),1,fil);
	fclose(fil);
	//delete filename;
	//}
}

void Hovedvindu::OpenHighscore(void)
{
	if(antiTestHighScore == 0)
	{
		return;
	}
	//wxMessageBox(_T("AMDMN222"),_T("ad"));
	//highscorelevel.Replace(".sgc",".hsl");
	//const wxChar *filename = highscorelevel;
	FILE *filer;

	//const wxChar *filenavn = hentfil.GetPath().c_str();
	//highscorelevel = filnavna.
	beat = true;

	filer = fopen(highscorelevel,"r+b");
	/*if(*filename==_T('\0'))
	{
		return;
	}*/
	fread(&score,sizeof(int),1,filer);
	fread(&highscorelevel,sizeof(wxString),1,filer);

	fread(&timeinfo,sizeof(tm),1,filer);



	fclose(filer);
	//delete filename;


}

void Hovedvindu::ID_Highscore(wxCommandEvent &event)
{
	if(gamestate == STATE_WIN || gamestate == STATE_OVER)
	{
		if(beat || once)
		{
		//OpenHighscore();
		once = false;
		}
		//wxString midlertidig = _T("test");
		//wxString midlertidig = highscorelevel;
		wxString highscorepopup = _T("Highscore for level: ") + wxString::Format(_T("%s"),urort) + _T("\n\nPoeng:") + wxString::Format(_T("%d"),tidligere);// + wxString::Format(_T("%s"),asctime(merkelig));
		wxMessageBox(highscorepopup,_T("Highscore"),wxICON_INFORMATION);
		score = 0;
	}
}