#include <windows.h>
#include <gl/gl.h>
#include "camera.h"

extern BOOL keys[256];

BOOL hold_keys[256];

extern CAMERA camera;

void SteerCamera(float ms)
{
	G3DVECTOR	target = camera.GetTarget();
	G3DVECTOR	pos;

	float ratio = ms / 8.0f;

	pos(camera.pos.x, camera.pos.y, camera.pos.z);

	if (keys['W'] == TRUE)
	{
		target = target * ratio;
		pos = pos + target;
	}

	if (keys['S'] == TRUE)
	{
		target = target * ratio;
		pos = pos - target;
	}

	if (keys['A'] == TRUE)
	{
		target.y = 0;
		target.Normalize();
		target.RotateY(rad(90.0f));
		target = target * ratio;
		pos = pos - target;
	}

	if (keys['D'] == TRUE)
	{
		target.y = 0;
		target.Normalize();
		target.RotateY(rad(90.0f));
		target = target * ratio;
		pos = pos + target;
	}

	if (keys[VK_CONTROL] == TRUE)
	{
		pos.y -= ratio;
	}

	if (keys[VK_SPACE] == TRUE)
	{
		pos.y += ratio;
	}

	camera.pos.x = pos.x;
	camera.pos.y = pos.y;
	camera.pos.z = pos.z;

	camera.SetCamera();
}

void MouseLook(WORD cx_screen, WORD cy_screen, WORD x, WORD y)
{
	if (x != cx_screen/2)
	{
		camera.hori += (short)(x - cx_screen/2) * 0.1f;
		SetCursorPos(cx_screen/2, cy_screen/2);
	}
	if (y != cy_screen/2)
	{
		camera.vert += (short)(y - cy_screen/2) * 0.1f;
		SetCursorPos(cx_screen/2, cy_screen/2);
	}
}