#include <windows.h>
#include "il.h"

extern void ilReverseBitmapRGB(BYTE *data, DWORD c_pixels);
extern void ilReverseBitmap(BYTE *data, WORD cx, WORD cy);

#include "fileholder.h"

#define TOTAL_PROGRESS_TASKS 440

HBITMAP hbt_prcts[21];
HDC hdc;
HDC mem;

extern DWORD scr_cx_res;
extern DWORD scr_cy_res;
extern HWND hWnd;

extern float img_cx_scale;
extern float img_cy_scale;

void ShowStartGraph(HWND hWnd)
{
	BITMAPINFOHEADER bth;
	BITMAPINFO bti;

	bth.biSize = sizeof(BITMAPINFOHEADER);
	bth.biWidth = 1024;
	bth.biHeight = 768;
	bth.biPlanes = 1;
	bth.biBitCount = 24;
	bth.biCompression = BI_RGB;
	bth.biSizeImage = 0;
	bth.biXPelsPerMeter = 0;
	bth.biXPelsPerMeter = 0;
	bth.biClrUsed = 0;
	bth.biClrImportant = 0;

	bti.bmiHeader = bth;
	bti.bmiColors ->rgbBlue = 255;
	bti.bmiColors ->rgbGreen = 255;
	bti.bmiColors ->rgbRed = 255;
	bti.bmiColors ->rgbReserved = 0;

	hdc = GetDC(hWnd);
	mem = CreateCompatibleDC(hdc);

	UINT image;
	ilInit();
	ilGenImages(1, &image);
	ilBindImage(image);
	ilLoadImage("data/2d/loader_back.jpg");
	ilReverseBitmap(ilGetData(), 1024 * 3, 768);
	ilReverseBitmapRGB(ilGetData(), 1024 * 768);
	HBITMAP hbt = CreateDIBitmap(hdc, &bth, CBM_INIT, ilGetData(), &bti, DIB_RGB_COLORS);
	ilDeleteImages(1, &image);

	SetForegroundWindow(hWnd);
	SelectObject(mem, hbt);
	StretchBlt(hdc, 0, 0, scr_cx_res, scr_cy_res, mem, 0, 0, 1024, 768, SRCCOPY);

	UINT prct;

	for (int i = 0; i < 21; i++)
	{
		ilGenImages(1, &prct);
		ilBindImage(prct);

		char prct_filename[256];
		wsprintf(prct_filename, "data/2d/prct%u.jpg", i * 2);
		ilLoadImage(prct_filename);
		ilReverseBitmap(ilGetData(), 96 * 3, 96);
		ilReverseBitmapRGB(ilGetData(), 96 * 96);

		bth.biWidth = 96;
		bth.biHeight = 96;
		bti.bmiHeader = bth;

		hbt_prcts[i] = CreateDIBitmap(hdc, &bth, CBM_INIT, ilGetData(), &bti, DIB_RGB_COLORS);
		ilDeleteImages(1, &prct);
	}

	DeleteObject(hbt);

	Sleep(1000);
}

void progressGo()
{
	static int current_progress = 0;

	SelectObject(mem, hbt_prcts[(current_progress * 21) / TOTAL_PROGRESS_TASKS]);
	StretchBlt(hdc, (int)(464.0f * img_cx_scale), (int)(321.0f * img_cy_scale), (int)(96.0f * img_cx_scale), (int)(96.0f * img_cy_scale), mem, 0, 0, 96, 96, SRCCOPY);

	current_progress ++;
	/*FileHolder x;

	x.create("xxx");
	x.writeInt(current_progress);
	x.close();*/
}

void progressReady()
{
	for (int i = 0; i < 21; i++)
		DeleteObject(hbt_prcts[i]);

	DeleteDC(mem);
	ReleaseDC(hWnd, hdc);
}