//Coded by asmCode 19:31 03-08-31

#include "G3DVector.h"

G3DVECTOR::G3DVECTOR()
{
}

G3DVECTOR::G3DVECTOR(float x, float y, float z)
{
	this ->x = x;
	this ->y = y;
	this ->z = z;
}

G3DVECTOR G3DVECTOR::operator * (G3DVECTOR source_vector)
{
	G3DVECTOR	ret;

	ret.x = (source_vector.y * z) - (y * source_vector.z);
	ret.y = (x * source_vector.z) - (source_vector.x * z);
	ret.z = (source_vector.x * y) - (x * source_vector.y);

	return ret;
}

BOOL G3DVECTOR::operator ==(G3DVECTOR source_vector)
{
	if ((x != source_vector.x) || (y != source_vector.y) || (z != source_vector.z))
		return FALSE;
	else
		return TRUE;
}

float G3DVECTOR::DotProduct(G3DVECTOR source_vector)
{
	return (x * source_vector.x) + (y * source_vector.y) + (z * source_vector.z);
}

float G3DVECTOR::VectorLength()
{
	return sqrtf(x*x + y*y + z*z);
}

void G3DVECTOR::Normalize()
{
	float proporcja = VectorLength();
	if (proporcja == 0.0f) return;
	x /= proporcja;
	y /= proporcja;
	z /= proporcja;
}

void G3DVECTOR::SetVectorLength(float length)
{
	float act_len = VectorLength();
	if (act_len == 0.0f) PostQuitMessage(0);//return;
	length /= act_len;

	x *= length;
	y *= length;
	z *= length;
}

void G3DVECTOR::CrossProductFrom3Points(G3DVECTOR p1, G3DVECTOR p2, G3DVECTOR p3)
{
	x = (p2.y - p1.y) * (p3.z - p1.z) - (p3.y - p1.y) * (p2.z - p1.z);
	y = (p2.z - p1.z) * (p3.x - p1.x) - (p3.z - p1.z) * (p2.x - p1.x);
	z = (p2.x - p1.x) * (p3.y - p1.y) - (p3.x - p1.x) * (p2.y - p1.y);
}

void G3DVECTOR::RotateX(float angle)
{
	float	sin_angle = sinf(angle);
	float	cos_angle = cosf(angle);
	float	temp_x = x;
	float	temp_y = y;
	float	temp_z = z;

	y = temp_y * cos_angle - temp_z * sin_angle;
	z = temp_y * sin_angle + temp_z * cos_angle;
}

void G3DVECTOR::RotateY(float angle)
{
	float	sin_angle = sinf(angle);
	float	cos_angle = cosf(angle);
	float	temp_x = x;
	float	temp_y = y;
	float	temp_z = z;

	x = temp_x * cos_angle - temp_z * sin_angle;
	z = temp_x * sin_angle + temp_z * cos_angle;
}

void G3DVECTOR::RotateZ(float angle)
{
	float	sin_angle = sinf(angle);
	float	cos_angle = cosf(angle);
	float	temp_x = x;
	float	temp_y = y;
	float	temp_z = z;

	x = temp_x * cos_angle - temp_y * sin_angle;
	y = temp_x * sin_angle + temp_y * cos_angle;
}

G3DVECTOR G3DVECTOR::operator * (float source_number)
{
	G3DVECTOR ret;

	ret.x = x * source_number;
	ret.y = y * source_number;
	ret.z = z * source_number;

	return ret;
}

G3DVECTOR G3DVECTOR::operator - (G3DVECTOR source_vector)
{
	G3DVECTOR	ret;
	
	ret.x = x - source_vector.x;
	ret.y = y - source_vector.y;
	ret.z = z - source_vector.z;

	return ret;
}

G3DVECTOR G3DVECTOR::operator + (G3DVECTOR source_vector)
{
	G3DVECTOR	ret;
	
	ret.x = x + source_vector.x;
	ret.y = y + source_vector.y;
	ret.z = z + source_vector.z;

	return ret;
}

void G3DVECTOR::Reset()
{
	x = 0.0f;
	y = 0.0f;
	z = 0.0f;
}

void G3DVECTOR::operator ()(float _x, float _y, float _z)
{
	x = _x;
	y = _y;
	z = _z;
}

void G3DVECTOR::Reverse()
{
	x = -x;
	y = -y;
	z = -z;
}

float G3DVECTOR::GetAngle(G3DVECTOR source_vector)
{
	float	angle;

	angle = DotProduct(source_vector);
	if (angle > 1.0f) angle = 1.0f;
	if (angle < -1.0f) angle = -1.0f;

	angle = acosf(angle);

	return angle;
}