#include <windows.h>
#include "resource.h"
#include <stdio.h>
#include "il.h"

extern DWORD scr_cx_res;
extern DWORD scr_cy_res;
extern DWORD scr_bpp;
extern DWORD scr_freq;

extern void ilReverseBitmap(BYTE *data, WORD cx, WORD cy);
extern void ilReverseBitmapRGB(BYTE *data, DWORD c_pixels);

HBITMAP LoadGraph(HWND hwnd)
{
	BITMAPINFOHEADER bth;
	BITMAPINFO bti;

	bth.biSize = sizeof(BITMAPINFOHEADER);
	bth.biWidth = 400;
	bth.biHeight = 200;
	bth.biPlanes = 1;
	bth.biBitCount = 24;
	bth.biCompression = BI_RGB;
	bth.biSizeImage = 0;
	bth.biXPelsPerMeter = 0;
	bth.biXPelsPerMeter = 0;
	bth.biClrUsed = 0;
	bth.biClrImportant = 0;

	bti.bmiHeader = bth;
	bti.bmiColors ->rgbBlue = 255;
	bti.bmiColors ->rgbGreen = 255;
	bti.bmiColors ->rgbRed = 255;
	bti.bmiColors ->rgbReserved = 0;

	UINT image;
	ilInit();
	ilGenImages(1, &image);
	ilBindImage(image);
	ilLoadImage("data/2d/setup.jpg");
	ilReverseBitmap(ilGetData(), 400 * 3, 200);
	ilReverseBitmapRGB(ilGetData(), 400 * 200);

	HDC hdc = GetDC(hwnd);
	HBITMAP hbt = CreateDIBitmap(hdc, &bth, CBM_INIT, ilGetData(), &bti, DIB_RGB_COLORS);
	ReleaseDC(hwnd, hdc);
	ilDeleteImages(1, &image);

	return hbt;
}

BOOL CALLBACK DP_Start(HWND hdlg, UINT message, WPARAM wparam, LPARAM lparam)
{
	DWORD disp_index;
	DEVMODE dv;
	char text_dev_mode[128];

	DWORD cur_sel;

	static HBITMAP	hbt;

	switch (message)
	{
	case WM_INITDIALOG:
		hbt = LoadGraph(hdlg);
		DWORD cx, cy;
		cx = GetSystemMetrics(SM_CXSCREEN);
		cy = GetSystemMetrics(SM_CYSCREEN);

		MoveWindow(hdlg, (cx - 400) / 2, (cy - 160) / 2, 400, 240, TRUE);

		disp_index = 0;

		while (EnumDisplaySettings(NULL, disp_index++, &dv))
		{
			wsprintf(text_dev_mode, "%dx%dx%dbpp %dHz", dv.dmPelsWidth, dv.dmPelsHeight, dv.dmBitsPerPel, dv.dmDisplayFrequency);
			SendDlgItemMessage(hdlg, IDC_DISPLAY, CB_ADDSTRING, 0, (LPARAM) text_dev_mode);
		}

		EnumDisplaySettings(NULL, ENUM_CURRENT_SETTINGS, &dv);
		wsprintf(text_dev_mode, "%dx%dx%dbpp %dHz", dv.dmPelsWidth, dv.dmPelsHeight, dv.dmBitsPerPel, dv.dmDisplayFrequency);
		cur_sel = (DWORD) SendDlgItemMessage(hdlg, IDC_DISPLAY, CB_FINDSTRING, 0, (LPARAM) text_dev_mode);
		SendDlgItemMessage(hdlg, IDC_DISPLAY, CB_SETCURSEL, cur_sel, 0);
		return FALSE;

	case WM_PAINT:
		HDC hdc;
		HDC mem;
	
		hdc = GetDC(hdlg);
		mem = CreateCompatibleDC(hdc);

		SelectObject(mem, hbt);
		BitBlt(hdc, 0, 0, 400, 200, mem, 0, 0, SRCCOPY);
		DeleteDC(mem);
		ReleaseDC(hdlg, hdc);

		return FALSE;

	case WM_COMMAND:
		switch (LOWORD(wparam))
		{
		case IDCANCEL:
			DeleteObject(hbt);
			EndDialog(hdlg, 0);
			break;

		case IDOK:
			cur_sel = (DWORD) SendDlgItemMessage(hdlg, IDC_DISPLAY, CB_GETCURSEL, 0, 0);
			SendDlgItemMessage(hdlg, IDC_DISPLAY, CB_GETLBTEXT, cur_sel, (LPARAM) text_dev_mode);
			sscanf(text_dev_mode, "%d%*c%d%*c%d%*s %d%*s", &scr_cx_res, &scr_cy_res, &scr_bpp, &scr_freq);
			EndDialog(hdlg, 1);
			break;
		}

		return TRUE;
	}

	return FALSE;
}