#include "atex2d.h"

aTex2D::aTex2D(void)
{
	tex_id = 0;
}

aTex2D::~aTex2D(void)
{
	release();
}

void aTex2D::reverseBitmap(BYTE *data, WORD cx, WORD cy)
{
	BYTE	*line = new BYTE[cx];

	for (WORD i = 0; i < (cy / 2); i++)
	{
		memcpy(line, (BYTE *)(data + cx * i), cx);
		memcpy((BYTE *)(data + cx * i), (BYTE *)(data + cx * (cy - i - 1)), cx);
		memcpy((BYTE *)(data + cx * (cy - i - 1)), line, cx);
	}

	delete [] line;
}

void aTex2D::loadFromFile(char *filename)
{
	char buf[100];
	GetCurrentDirectory(100, buf);

	static BOOL b_il_init;

	if (!b_il_init)
	{
		ilInit();
		b_il_init = TRUE;
	}

	UINT image;
	ilGenImages(1, &image);
	ilBindImage(image);
	ilLoadImage(filename);

	cx = ilGetInteger(IL_IMAGE_WIDTH);
	cy = ilGetInteger(IL_IMAGE_HEIGHT);
	bpp = ilGetInteger(IL_IMAGE_BPP);

	BYTE *data = new BYTE[cx * cy * (bpp / 1)];
	memcpy(data, ilGetData(), cx * cy * (bpp / 1));
	ilDeleteImages(1, &image);

	reverseBitmap(data, cx * (bpp / 1), cy);

	glGenTextures(1, &tex_id);

	glBindTexture(GL_TEXTURE_2D, tex_id);

	//glTexImage2D(GL_TEXTURE_2D, 0, 3, cx, cy, 0, GL_RGB, GL_UNSIGNED_BYTE, data);
	gluBuild2DMipmaps(GL_TEXTURE_2D, bpp, cx, cy, GL_RGB, GL_UNSIGNED_BYTE, data); 

	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
}

void aTex2D::createTexture(int width, int height, int bpp)
{
}

void aTex2D::release()
{
	if (tex_id != 0)
	{
		glDeleteTextures(1, &tex_id);
		tex_id = 0;
	}
}

void aTex2D::bindTex()
{
	glBindTexture(GL_TEXTURE_2D, tex_id);
}

UINT aTex2D::getTexId()
{
	return tex_id;
}