//
// Hemisphere Lighting Model
// Copyright (c) Microsoft Corporation. All rights reserved.
//
// Note: This effect file works with EffectEdit.
//


string XFile = "\\code\\oma\\c#\\mozz\\valmis\\data\\testipallo.x";
int    BCLR  = 0xff202080;                  // background

float time : TIME;
float spherify = 1;
float GeomInset = 0.003;
float ShadowExtrudeDist = 100;

float4 LightPos = { 0,100,0,0 };

float3 SurfColor = {1,.9,.8};

// transformations
float4x4 WorldViewProj  : WORLDVIEWPROJECTION;
float4x4 Projection : PROJECTION;
float4x4 World : WORLD;
float4x4 View : VIEW;

struct VS_OUTPUT
{
    float4 Pos  : POSITION;
    float4 Diff : COLOR0;
//    float4 Spec : COLOR1;
};

//VS_OUTPUT VS

float4 getPos(
    float4 Pos  : POSITION
//    float  Occ  : TEXCOORD0
    )
{
return Pos;
    VS_OUTPUT Out;// = (VS_OUTPUT)0;

	spherify = 0.01;

    // spherify
    float4 p = Pos;
    p = normalize(p);
    p*=64;
    p.w = Pos.w;
    p = lerp( p, Pos, spherify );
/**/

    
    float dis = length( p );
    

    float d2 = (1/dis) * 3.14156;

    float2 p1 = float2( p.x, p.y );
    float d1 = length( p1 );
    float a1 = atan2( p1.x, p1.y );

    a1+=(d2 * 2) * sin( time * 2 );

    p.x = d1 * sin( a1 );
    p.y = d1 * cos( a1 );

    p1 = float2( p.x, p.z );
    d1 = length( p1 );
    a1 = atan2( p1.x, p1.y );

    a1+=(d2 * 3 ) * cos( time  );

    p.x = d1 * sin( a1 );
    p.z = d1 * cos( a1 );

	return p;
}
/*

    float4 posProj = mul( p, World );
    posProj = mul( posProj, View );
    posProj = mul( posProj, Projection );
    Out.Pos  = posProj;

    dis = (1+sin( Pos.x/10 + dis )) / 2;
    Out.Diff = float4(dis,dis,dis,1);
//    Out.Spec = Out.Diff;

    return Out.Pos;
}*/


VS_OUTPUT backingVS( 
	float4 Pos : POSITION,
	float3 Norm : NORMAL 
	)
{
    VS_OUTPUT OUT;
	Pos = getPos( Pos );
	OUT.Pos = mul( Pos, WorldViewProj);
    OUT.Diff = float4(0.1,0.1,0.1,1);
    // OUT.TexCoord0 = float4(0, 0, 0, 1);
    return( OUT );
}



VS_OUTPUT extrudeVS( 
	float4 Pos : POSITION,
	float3 Norm: NORMAL
	)
{
	VS_OUTPUT OUT;

	Pos = getPos( Pos );

    float4 Lvec = normalize( Pos - LightPos );

    float ldn = dot( -Lvec.xyz, Norm.xyz );

    float4 inset_pos = float4((( Pos.xyz - ( Norm * GeomInset)).xyz), Pos.w);
//    float4 inset_pos = float4((( Pos.xyz - ( Norm * GeomInset)).xyz), 1);

    float4 extrusion_vec = Lvec * ShadowExtrudeDist;

    float toggle = (float) (ldn < 0.0);

    float4 new_position = extrusion_vec*toggle + inset_pos;

//	OUT.Pos = getPos( new_position );
    OUT.Pos = mul( new_position, WorldViewProj);

	OUT.Diff = float4(1,1,1,1);
	OUT.Diff = OUT.Pos;
//    OUT.Diff		= float4(UV.xy,0,1);
    // OUT.TexCoord0	= IN.TexCoord0.xyyy;
    return( OUT );
}


VS_OUTPUT simpleVS( float4 Pos : POSITION,
	float3 Norm : NORMAL )
{
	Pos = getPos( Pos );
    VS_OUTPUT OUT;
    float4 Lvec = normalize( Pos - LightPos );
    float ldn = abs(dot(-Lvec.xyz, Norm ));

    OUT.Pos = mul( Pos, WorldViewProj );

	OUT.Diff = float4( OUT.Pos.xyz, 1 );
	OUT.Diff = float4( 1,1,1,1 );
    OUT.Diff = float4((ldn*SurfColor),0.1);
//OUT.Diff = float4(1,1,1,1);
    // OUT.TexCoord0 = float4(0,0,0,1);
    return( OUT );
}

technique PASKA
{
	pass P0
	{
      	VertexShader = compile vs_2_0 backingVS();
		ZEnable = true;
		ZWriteEnable = true;
		CullMode = None;
		StencilEnable = false;
		
	}
	pass P1
	{
      	VertexShader = compile vs_2_0 extrudeVS();

		ZEnable = true;
		ZWriteEnable = true;
		ZFunc = lessequal;
		CullMode = CW;
		StencilEnable = True;
		StencilPass = Keep;
		StencilFail = Keep;
		StencilZFail = IncrSat;
		StencilFunc = Always;
		ColorWriteEnable = 0;
    }

    pass P2
	{

		VertexShader = compile vs_2_0 extrudeVS();
		ZEnable = true;
		ZWriteEnable = true;
		ZFunc = lessequal;
		CullMode = CCW;
		// TwoSidedStencilMode = false; // needed?
		StencilEnable = True;
		StencilPass = Keep;
		StencilFail = Keep;
		StencilZFail = DecrSat;
		StencilFunc = Always;
		ColorWriteEnable = 0;
    }

    pass P3
	{
		VertexShader = compile vs_1_1 simpleVS();
		ZEnable = true;
		ZWriteEnable = false;
		CullMode = None;
		StencilEnable =  True;
		StencilPass = Keep;
		StencilZFail = Keep;
		StencilFail = Keep;
		StencilRef = 0;
		StencilFunc = Equal;

		ColorWriteEnable = 0xffffff;
    }

    pass P4
	{
		VertexShader = compile vs_1_1 simpleVS();
		ZEnable = false;
		CullMode = None;
		StencilEnable =  false;
		alphaBlendEnable = true;
		BlendOp = ADD;
	DestBlend  = one;
	srcBlend = srcalpha;

		ColorWriteEnable = 0xffffff;
    }

}

technique showVolume
 {
    pass P0
	{
		VertexShader = compile vs_2_0 extrudeVS();
		ZEnable = true;
		ZWriteEnable = true;
		CullMode = CCW; // None;
		StencilEnable = false;
    }
}

technique simple 
{
    pass layZ 
 {		
		VertexShader = compile vs_1_1 simpleVS();
		ZEnable = true;
		ZWriteEnable = true;
		CullMode = None;
		StencilEnable = false;
    }
}