<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:fn="http://www.w3.org/2004/07/xpath-functions" xmlns:xdt="http://www.w3.org/2004/07/xpath-datatypes">
	<xsl:output method="xml" version="1.0" encoding="UTF-8" indent="yes"/>

	<xsl:template match="/">
		<html>
			<head>
				<link rel="STYLESHEET" type="text/css" href="ReleaseNotes.css"/>
				<title>Ventuz Release Notes</title>
			</head>
			<body>
				<xsl:apply-templates/>
			</body>
		</html>
	</xsl:template>	
		
	<xsl:template match="//Product">
		<span class="pgtitle"><xsl:value-of select="@Name"/></span><br/><br/><br/>
		<xsl:apply-templates/>
	</xsl:template>
	
	<xsl:template match="Version">
		<span class="boldorange"><xsl:value-of select="@Value"/></span>
		<table cellspacing="4" cellpadding="0" border="0" width="450">
			<tbody>
					<xsl:apply-templates/>
			</tbody>
		</table>
	</xsl:template>
	
	<xsl:template match="Notes">
		<tr>
			<td width="100" valign="top"><xsl:value-of select="@Type"/></td>
			<td width="50" valign="top"><xsl:value-of select="@Prefix"/><xsl:value-of select="@Id"/></td>
			<td><xsl:value-of select="."/></td>
		</tr>
		<tr><td colspan="3"> </td></tr>
	</xsl:template>
	
	
</xsl:stylesheet>
