/*
 * Decompiled with CFR 0.152.
 */
package resident;

import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.GameCanvas;
import resident.MathFP;

public class RecTrees
extends GameCanvas {
    private int timer;
    private int nOfIter = 7;
    private int angle = MathFP.toFP("0.002");
    private int shrink = MathFP.toFP("1.55");
    private int WIDTH = 176;
    private int HEIGHT = 208;
    private int c = MathFP.toFP("0.6");
    private int d = MathFP.toFP("0.002");
    private int zzOne = MathFP.toFP("0.01");
    private Image view;
    private Image dream;
    private Font textFont = Font.getFont((int)0, (int)1, (int)16);
    private int bars = 0;
    private int barTimer = 0;
    private int barCloser = 0;
    private int arc = 0;

    protected RecTrees() {
        super(true);
        try {
            this.view = Image.createImage((String)"/desert.png");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void rec(int px, int py, int dx, int dy, int s, int n, Graphics g) {
        int px2 = MathFP.add(px, MathFP.mul(s, dx));
        int py2 = MathFP.add(py, MathFP.mul(s, dy));
        g.drawLine(MathFP.toInt(px), MathFP.toInt(py), MathFP.toInt(px2), MathFP.toInt(py2));
        if (n >= this.nOfIter) {
            return;
        }
        px = MathFP.add(px, MathFP.mul(s, dx));
        py = MathFP.add(py, MathFP.mul(s, dy));
        s = MathFP.div(s, this.shrink);
        int dx2 = MathFP.add(MathFP.mul(MathFP.cos(this.angle), dx), MathFP.mul(MathFP.sin(this.angle), dy));
        int dy2 = MathFP.add(MathFP.mul(-MathFP.sin(this.angle), dx), MathFP.mul(MathFP.cos(this.angle), dy));
        this.rec(px, py, dx2, dy2, s, ++n, g);
        dx2 = MathFP.add(MathFP.mul(MathFP.cos(-this.angle), dx), MathFP.mul(MathFP.sin(-this.angle), dy));
        dy2 = MathFP.add(MathFP.mul(-MathFP.sin(-this.angle), dx), MathFP.mul(MathFP.cos(-this.angle), dy));
        this.rec(px, py, dx2, dy2, s, n, g);
    }

    private void colorBars(Graphics g) {
        int barSize = this.barTimer;
        if (this.barTimer > 200) {
            barSize = 200;
        }
        int i = 0;
        while (i < barSize) {
            int k = MathFP.sin(i * this.bars * 2) / 75 + 100;
            int k1 = MathFP.sin(i * this.bars * 4) / 75 + 100;
            int k2 = MathFP.sin(i * this.bars * 6) / 75 + 100;
            g.setColor(k % 255, k1 % 255, k2 % 255);
            g.fillRect(0, this.HEIGHT / 2 - i / 2 - 15 - this.barCloser, this.WIDTH, 30);
            g.fillRect(0, this.HEIGHT / 2 + i / 2 - 15 + this.barCloser, this.WIDTH, 30);
            ++i;
        }
        this.bars = MathFP.sin(this.barTimer * 400) / 75 + 100;
        if (this.barTimer > 250) {
            this.barCloser += 3;
        }
        ++this.barTimer;
    }

    private void arcGrow(Graphics g) {
        g.setColor(0, 0, 0);
        g.fillArc(this.WIDTH / 2 - this.arc, this.HEIGHT / 2 - this.arc, this.arc * 2, this.arc * 2, 0, 360);
        this.arc += 3;
    }

    public void setImage(Image img) {
        this.dream = img;
    }

    public void draw(Graphics g) {
        if (this.timer > 250) {
            g.drawImage(this.view, 0, 0, 0);
            if (this.timer > 305) {
                if (this.angle > this.c || this.angle < this.d) {
                    this.zzOne = -this.zzOne;
                }
                this.angle = MathFP.add(this.angle, this.zzOne);
            }
            g.setColor(0, 0, 0);
            this.rec(MathFP.toFP(159), MathFP.toFP(208), MathFP.toFP(-4), MathFP.toFP(-6), MathFP.toFP(5), 1, g);
            this.rec(MathFP.toFP(30), MathFP.toFP(208), MathFP.toFP(3), MathFP.toFP(-7), MathFP.toFP(6), 1, g);
            this.rec(MathFP.toFP(72), MathFP.toFP(208), MathFP.toFP(0), MathFP.toFP(-5), MathFP.toFP(12), 1, g);
            g.setFont(this.textFont);
            int sin1 = MathFP.sin(this.timer * 400) / 75;
            g.setColor(235, (sin1 + 100) % 255, (sin1 + 100) % 255);
            g.drawString("REALTIME FRACTAL TREES ..!", sin1, 10, 0);
        }
        if (this.timer < 290) {
            if (this.timer < 250) {
                g.drawImage(this.dream, 0, 0, 0);
            }
            this.colorBars(g);
        }
        if (this.timer > 400) {
            this.arcGrow(g);
        }
        ++this.timer;
    }
}

