;******************************************************************************
; mcube.asm
; 2006/11/05
; Martin Veilleux
;******************************************************************************
;==============================================================================
; INCLUDES
;==============================================================================
;==============================================================================
; DEFINITIONS
;==============================================================================
;==============================================================================
; MACROS
;==============================================================================
;==============================================================================
section .data
;==============================================================================
mcubeCampos: dd  0.0, 0.0, -0.96
mcubeAmpl: dd 1.2
fieldinfo: dd 2.0,2.0,2.0, 0,0,0, 24,24,24, 1.0,5,mcubeFieldobj
skycube:
dd 0,0,0,1.01,_MCUBE_hexa,PACKB2DW(0,0,MCUBEF_REV,8)

mcubelights:
dd 0.9,0.8,0.8,0, 0,0,1.0,0, 0.7,0.7,0.7,0.0
dd 0,0,PACKB2DW(0,0,LIGHT_AMBIENT,1)
dd -0.9,-0.9,-0.9,0, 0,0,0,0, 0.8,1.2,1.5,0.0
dd 2.0,0.25,PACKB2DW(0,LIGHTF_RANGE,LIGHT_POS,1)
;==============================================================================
section .bss
;==============================================================================
mcubeFieldobj: resb mcubeobj_size*8
;==============================================================================
section .text
;==============================================================================
SDECL _updateMcubeCam, 0
;==============================================================================
    CCALL   _getTimeMat, RTmatrix, 57279, 49741,[beatTimer +timer.sec]
    CameraSetRot RAS_main +raster.cam, RTmatrix
    M33mulV3 RTmatrix +matrix.t,RTmatrix, mcubeCampos
    CameraSetPos RAS_main +raster.cam, RTmatrix +matrix.t
;    CameraUpdate RAS_main +raster.cam
    CCALL   _setCamFOV, RAS_main +raster.cam, REAL_PID3
.exit:
DECLEND
;==============================================================================
SDECL _updateMBall, 0
;==============================================================================
    MPUSH   edi,ebp
    LCTX    ebp
    LARG    4, _ball, _ta, _tx, _ty, _tz, _rad
    LVAR    4, ampl
    LENTER
    
    CCALL   _FN_sin, [RTM_time], 0, [mcubeAmpl], [greal2000pi], [%$_ta], 0
    fstp    dword[%$ampl]

    mov     edi,dword[%$_ball]
    CCALL   _FN_sin, [RTM_time], 0, [%$ampl], [greal2000pi], [%$_tx], 0
    fstp    dword[edi +mcubeobj.x]
    CCALL   _FN_sin, [RTM_time], 0, [%$ampl], [greal2000pi], [%$_ty], 0
    fstp    dword[edi +mcubeobj.y]
    CCALL   _FN_sin, [RTM_time], 0, [%$ampl], [greal2000pi], [%$_tz], 0
    fstp    dword[edi +mcubeobj.z]
    mov     dword[%$ampl],20
    fild    dword[%$_rad]
    fidiv   dword[%$ampl]
    fstp    dword[edi +mcubeobj.rad]
    mov     dword[edi +mcubeobj.fn],_MCUBE_sphere
    mov     dword[edi +mcubeobj.pow],PACKB2DW(0,0,0,2)
.exit:
    LEXIT
    MPOP    edi,ebp
DECLEND
;==============================================================================
SDECL _updateMcube, 0
;==============================================================================
    CCALL   _updateMcubeCam

    Memcpy  mcubeFieldobj, skycube, mcubeobj_size
    CCALL   _updateMBall, mcubeFieldobj +mcubeobj_size*1,7666,7546,2242,8123,2
    CCALL   _updateMBall, mcubeFieldobj +mcubeobj_size*2,5297,4571,3287,6666,1
    CCALL   _updateMBall, mcubeFieldobj +mcubeobj_size*3,13847,7777,9876,2432,2
    CCALL   _updateMBall, mcubeFieldobj +mcubeobj_size*4,19555,15246,5242,18123,1

    CCALL   _getTimeMat, RTmatrix, 56666, 54328,[beatTimer +timer.sec]
    V3smul  mcubelights +light.pos +light_size, RTmatrix +matrix.n, mcubelights
;set light color
    CCALL   _FN_sin, [RTM_time], REAL_1, [Real1d2], [greal2000pi], 10000, 0
    fstp    dword[mcubelights +light.c +light_size +rgbaUP.b]
    CCALL   _FN_sin, [RTM_time], REAL_1, [Real1d2], [greal2000pi], 15238, 0
    fstp    dword[mcubelights +light.c +light_size +rgbaUP.g]
    CCALL   _FN_sin, [RTM_time], REAL_1, [Real1d2], [greal2000pi], 18121, 0
    fstp    dword[mcubelights +light.c +light_size +rgbaUP.r]
DECLEND
;==============================================================================
SDECL _VPGM_mcube
;==============================================================================
    MPUSH   ebx
    LCTX    esp
    LARG    4, _pvert
    
    mov     edx,dword[%$_pvert]
    lea     edx,[edx +vertex.nx]
    M33mulV3 RTmatrix +matrix.t,RTmatrix,edx

    mov     edx,dword[%$_pvert]
    fld     dword[RTmatrix +matrix.t +vec3.y]
;    fld     st0
;    fabs
;    fmulp   st1
    fld     dword[RTmatrix +matrix.t +vec3.x]
;    fld     st0
;    fabs
;    fmulp   st1
    fld     dword[RAS_main +raster.xtinfo +xtexinfo.uvMaxD2]
    fmul to st1
    fmul to st2
    fadd to st1
    faddp   st2
    fstp    dword[edx +vertex.u0]
    fstp    dword[edx +vertex.v0]


    mov     eax,REAL_FIX8
    mov     dword[edx +vertex.c +rgbaUP.b],eax
    mov     dword[edx +vertex.c +rgbaUP.g],eax
    mov     dword[edx +vertex.c +rgbaUP.r],eax
    
    lea     eax,[edx +vertex.nx]
    lea     ebx,[edx +vertex.c]
    CCALL   _LIGHT_apply, ebx, edx, eax, mcubelights, 2
.exit:
    MPOP    ebx
DECLEND
;==============================================================================
SDECL _renderMcube, 0
;==============================================================================
    TexClear    myscene +scene.fb
    TexClear    myscene +scene.zb
    CCALL   _updateMcube
    CCALL   _getTimeMat, RTmatrix, 86666, 84328,[beatTimer +timer.sec]

    RasSetTex   0, gtexWavy2
    RasSetCulling CULLING_BACK
    RasSetFpgm _FPGM_RGBxT0bi_Z
    RasSetVpgm _VPGM_RGBT0

    ObjSetVpgm _VPGM_mcube
    ObjSetFlags 0, 0, OBJF_NORM
    CCALL   _MCUBE_render3D, fieldinfo
.exit:
DECLEND
;==============================================================================
