;******************************************************************************
; disco.asm
; 2006/11/05
; Martin Veilleux
;******************************************************************************
;==============================================================================
; INCLUDES
;==============================================================================
;==============================================================================
; DEFINITIONS
;==============================================================================
TCTX    discob
TVAR    discob.rad  ,4
TVAR    discob.tileW ,4
TVAR    discob.biasRatio ,4
TVAR    discob.flags    ,4
ENDT    discob

TCTX    laserPS
TVAR    laserPS.data  ,4
TVAR    laserPS.count ,4
TVAR    laserPS.minttl ,4
TVAR    laserPS.maxttl ,4
TVAR    laserPS.fadetm  ,4
TVAR    laserPS.rad    ,4
TVAR    laserPS.seed1 ,4
TVAR    laserPS.seed2 ,4
TVAR    laserPS.c     ,rgbaUP_size
ENDT    laserPS

%assign DISCOF_REV_NORMALS 0x01
;==============================================================================
; MACROS
;==============================================================================
;==============================================================================
section .data
;==============================================================================
%ifdef _DISCO_BEAT_
discoBeat: dd 2.3333333,1.0,2.5,0
%endif
discoCamRadMin: dd -0.88
discoTileScale1: dd 0.025,0.025,0.005
discoRotSpeed1: dd 0.5
discoTileScale2: dd 0.1,0.1,0.02
discoRotSpeed2: dd -0.5
discoSharpMin: dd 0.08
discoSharpAmpl: dd 0.07
gDisco: dd 0.3,0.025,0.4,0
gDisco2: dd 1.0,0.1,0.4,DISCOF_REV_NORMALS
discoStaticBeam:
dd gZero,AxisY,0,0.1,2.0, 245.0,192.0,160.0,0,gtexFlare1d,gtexFlare,BEAMF_OFFSET
AxisY: dd 0,1.0,0
discoLasers:
dd 0,0,0.5,0.5,0.24,0.1,0x81393,0xfafeef, 128.0,144.0,225.0,0

;==============================================================================
section .bss
;==============================================================================
discoTileSharp: resd 1
%ifdef _DISCO_BEAT_
discoTimer: resb timer_size
%endif
;==============================================================================
section .text
;==============================================================================
SDECL _initDisco, 0
;==============================================================================
    CCALL   _PS_init, discoLasers, 20
    imul    eax,dword[discoLasers +laserPS.count],photon_size
    Memset  [discoLasers +laserPS.data],0, eax
%ifdef _DISCO_BEAT_
    TimerReset discoTimer
%endif
DECLEND
;==============================================================================
SDECL _updateLasers, 0
;==============================================================================
    MPUSH   esi,edi,ebp
    LCTX    ebp
    LARG    4, _dt
    LVAR    4, count
    LENTER
    mov     esi,discoLasers
    mov     eax,dword[esi +laserPS.count]
    mov     dword[%$count],eax
    mov     edi,dword[esi +laserPS.data]
.iterLaser:
    fld     dword[edi +photon.ttl]
    fsub    dword[%$_dt]
    fst     dword[edi +photon.ttl]
    _FCOMP_MEM dword[Real1d1k]
    jnc     .next
;reinit laser
    lea     eax,[esi +laserPS.seed1]
    RandFqd eax
    fmul    dword[esi +laserPS.maxttl]
    fadd    dword[esi +laserPS.minttl]
    fst     dword[edi +photon.maxttl]
    fstp    dword[edi +photon.ttl]
    
    lea     eax,[esi +laserPS.seed2]
    CCALL   _getRandMat,eax
    V3eq    edi +photon.x, RTmatrix +matrix.n
.next:
    add     edi,photon_size
    dec     dword[%$count]
    jnz     .iterLaser
.exit:
    LEXIT
    MPOP    esi,edi,ebp
DECLEND
;==============================================================================
SDECL _renderLasers, 0
;==============================================================================
    MPUSH   esi,edi,ebp
    LCTX    ebp
    LVAR    beam_size, lbeam
    LVAR    vec3_size, pos
    LVAR    4, count, rcpFade
    LENTER
    mov     esi,discoLasers
    RasSetFpgm _FPGM_RGBxT0add_Z    
    mov     dword[%$lbeam +beam.tex],gtexFlare1d
    fld     dword[gDisco2 +discob.rad]
    fsub    dword[gDisco +discob.rad]
    fstp    dword[%$lbeam +beam.len]
    xor     eax,eax
    mov     dword[%$lbeam +beam.flags],eax
    V4eq    %$lbeam +beam.color, esi +laserPS.c
    lea     eax,[%$pos]
    mov     dword[%$lbeam +beam.p1],eax
    fld     dword[esi +laserPS.rad]
    fdiv    dword[esi +laserPS.fadetm]
    fstp    dword[%$rcpFade]
    
    mov     eax,dword[esi +laserPS.count]
    mov     dword[%$count],eax
    mov     edi,dword[esi +laserPS.data]
.iterLaser:
    fld     dword[edi +photon.ttl]
    _FCOMP_MEM dword[Real1d1k]
    jc      .next
;comp rad
    fld     dword[edi +photon.ttl]
    _FCOM_MEM dword[esi +laserPS.fadetm]
    jc      .compRad
    fsubr   dword[edi +photon.maxttl]
    _FCOM_MEM dword[esi +laserPS.fadetm]
    jc      .compRad
    ffreep  st0
    fld     dword[esi +laserPS.fadetm]
.compRad:
    fmul    dword[%$rcpFade]
    fst     dword[%$lbeam +beam.diam]
    _FCOMP_MEM dword[Real1d1k]
    jc      .next
    V3smul  %$pos, edi +photon.x, gDisco +discob.rad
    mov     dword[%$lbeam +beam.dir],edi
    xor     eax,eax
    mov     dword[%$lbeam +beam.angle],eax
    lea     eax,[%$lbeam]
    CCALL   _BEAM_render, eax
    mov     dword[%$lbeam +beam.angle],REAL_PID2
    lea     eax,[%$lbeam]
    CCALL   _BEAM_render, eax
    
.next:
    add     edi,photon_size
    dec     dword[%$count]
    jnz     .iterLaser
.exit:
    LEXIT
    MPOP    esi,edi,ebp
DECLEND
;==============================================================================
SDECL _DISCOB_renderVertBeam, 0
;==============================================================================
    RasSetFpgm _FPGM_RGBxT0add_Z    
    xor     eax,eax
    mov     dword[discoStaticBeam +beam.angle],eax
    CCALL   _BEAM_render, discoStaticBeam
    mov     dword[discoStaticBeam +beam.angle],REAL_PID2
    CCALL   _BEAM_render, discoStaticBeam
.exit:
DECLEND
;==============================================================================
SDECL _DISCOB_render, 0
;==============================================================================
    MPUSH   esi,ebp
    LCTX    ebp
    LARG    4, _info, _rmat
    LVAR    4, stride, rowMax, tMax, bias
    LVAR    4, rowRad, rowCount, tCount, dist
    LVAR    vec3_size, pos, nAt, nRight, da
    LVAR    vec3_size, bnorm
    LENTER
    
    mov     edx,[%$_rmat]
    V3sub   %$bnorm, RAS_main +raster.cam +camera.rm +matrix.t, edx +matrix.t
    lea     eax,[%$bnorm]
    V3norm  eax
    mov     esi,dword[%$_info]
    mov     dword[%$bias],REAL_1D1000
;comp max rows of tiles, 2piR/(2*stride)
    fldpi
    fmul    dword[esi +discob.rad]
    fld     dword[esi +discob.tileW]
    fmul    dword[esi +discob.biasRatio]
    fadd    dword[esi +discob.tileW]
    fst     dword[%$stride]
    fdivp   st1
    fistp   dword[%$rowMax]
;comp da
    fldpi
    fidiv   dword[%$rowMax]
    mov     dword[%$rowCount],1
    dec     dword[%$rowMax]
    fstp    dword[%$da +vec3.y]
.iterRows:
    fld     dword[%$da +vec3.y]
    fimul   dword[%$rowCount]
    fsincos
;cos is the y pos, sin is the radius formed by the row circle
    fmul    dword[esi +discob.rad]
    fst     dword[%$nRight +vec3.y]
    fstp    dword[%$pos +vec3.y]
    fmul    dword[esi +discob.rad]
    fabs
    fstp    dword[%$rowRad]
;comp max tiles for this row
    fldpi
    fadd    st0
    fld     st0
    fmul    dword[%$rowRad]
    fdiv    dword[%$stride]
    fistp   dword[%$tMax]
;comp daX
    fidiv   dword[%$tMax]
    xor     eax,eax
    mov     dword[%$tCount],eax
    fstp    dword[%$da +vec3.x]
.iterTiles:
    fld     dword[%$da +vec3.x]
    fimul   dword[%$tCount]
    fld     st0
    fsincos
    fmul    dword[%$rowRad]
    fstp    dword[%$pos +vec3.x]
    fmul    dword[%$rowRad]
    fstp    dword[%$pos +vec3.z]
;find a close normal for matrix comp
    fadd    dword[%$bias]
    fsincos
    fmul    dword[%$rowRad]
    fstp    dword[%$nRight +vec3.x]
    fmul    dword[%$rowRad]
    fstp    dword[%$nRight +vec3.z]
;apply rotation before comp tile rotation
    lea     eax,[%$pos]
    M33mulV3 OBJ_tform +objtform.srm +matrix.n, [%$_rmat],eax
    lea     eax,[%$nRight]
    M33mulV3 OBJ_tform +objtform.srm +matrix.u, [%$_rmat],eax
    lea     eax,[%$pos]
    M33mulAddV3 OBJ_tform +objtform.rm +matrix.t, [%$_rmat],eax
    V3cross OBJ_tform +objtform.srm +matrix.v,OBJ_tform +objtform.srm +matrix.n,OBJ_tform +objtform.srm +matrix.u
    V3cross OBJ_tform +objtform.srm +matrix.u,OBJ_tform +objtform.srm +matrix.v,OBJ_tform +objtform.srm +matrix.n
    V3norm  OBJ_tform +objtform.srm +matrix.n
;visibility test
    V3dot   OBJ_tform +objtform.srm +matrix.n,OBJ_tform +objtform.rm +matrix.t
    fstp    dword[%$dist]
    V3dot   OBJ_tform +objtform.srm +matrix.n,RAS_main +raster.cam +camera.rm +matrix.t
    test    byte[esi +discob.flags],DISCOF_REV_NORMALS
    jz      .endRevN
    fchs
    xor     dword[%$dist],REAL_SIGNMASK
.endRevN:
    _FCOMP_MEM dword[%$dist]
    jc      .next
    V3norm  OBJ_tform +objtform.srm +matrix.v
    V3norm  OBJ_tform +objtform.srm +matrix.u
    M33transpose OBJ_tform +objtform.rm,OBJ_tform +objtform.srm
    CCALL   _OBJ_render3D
.next:
    inc     dword[%$tCount]
    dec     dword[%$tMax]
    jnz     .iterTiles
;next row
    inc     dword[%$rowCount]
    dec     dword[%$rowMax]
    jnz     .iterRows
    
.exit:
    LEXIT
    MPOP    esi,ebp
DECLEND
;==============================================================================
SDECL _VPGM_disco
;==============================================================================
    MPUSH   edi,ebp
    LCTX    ebp
    LARG    4, _pvert
    LVAR    vec3_size, norm
    LENTER
    
    mov     edi,dword[%$_pvert]
    lea     eax,[edi +vertex.nx]
    lea     edx,[%$norm]
    V3interpolate edx,OBJ_tform +objtform.norm,eax,[discoTileSharp]
;set tex coord
    fld     dword[%$norm +vec3.y]
    fld     dword[%$norm +vec3.x]
    fld     dword[RAS_main +raster.xtinfo +xtexinfo.uvMaxD2]
    fmul to st1
    fmul to st2
    fadd to st1
    faddp   st2
    fstp    dword[edi +vertex.u0]
    fstp    dword[edi +vertex.v0]
%ifdef _DISCO_MULTITEX_
    lea     edx,[%$norm]
    M33mulV3    edx, RAS_main +raster.cam +camera.irm, edx
    fld     dword[%$norm +vec3.y]
    fld     dword[%$norm +vec3.x]
    fld     dword[RAS_main +raster.xtinfo +xtexinfo.uvMaxD2 +xtexinfo_size]
    fmul to st1
    fmul to st2
    fadd to st1
    faddp   st2
    fstp    dword[edi +vertex.u1]
    fstp    dword[edi +vertex.v1]
%endif
.exit:
    LEXIT
    MPOP    edi,ebp
DECLEND
;==============================================================================
SDECL _setDiscoCam, 0
;==============================================================================
    LCTX    esp
    LVAR    4, result

    CCALL   _setCamFOV, RAS_main +raster.cam, REAL_PID4
%ifdef _DISCO_BEAT_
    CCALL   _getTimeMat,RTmatrix,38279,29741,[discoTimer +timer.sec]
%else
    CCALL   _getTimeMat,RTmatrix,28279,19741,[RTM_time]
%endif
    CCALL   _setMovingCam, [discoCamRadMin]
.exit:
DECLEND
;==============================================================================
SDECL _updateDisco, 0
;==============================================================================
    CCALL   _updateLasers,[RTM_dt]
%ifdef _DISCO_BEAT_
    CCALL   _updateCustomBeat, discoTimer, discoBeat
    TimerUpdate discoTimer, [RTM_dt]
%endif
.exit:
DECLEND
;==============================================================================
SDECL _renderUpdateDisco, 0
;==============================================================================
    CCALL   _FN_sin, [RTM_time], [discoSharpMin], [discoSharpAmpl], [greal2000pi], 8000, [gZero]
    fstp    dword[discoTileSharp]
    
    CCALL   _setDiscoCam
.exit:
DECLEND
;==============================================================================
SDECL _renderDisco, 0
;==============================================================================
    TexClear myscene +scene.fb
    TexClear myscene +scene.zb
    CCALL   _renderUpdateDisco

    ObjSetVpgm _VPGM_disco
    ObjSetFlags OBJ_CUBE, 0, OBJF_LIGHT
    RasSetCulling CULLING_BACK
    RasSetFpgm _FPGM_T0bi_Z
    RasSetVpgm _VPGM_T0
    RasSetTex 0,gtexBluestreak
;    RasSetTex 1,gtexFont

    V3setNull RTmatrix +matrix.t
;inner disco ball
    fld     dword[RTM_time]
    fmul    dword[discoRotSpeed1]
    fstp    dword[RTmatrix]
    xor     eax,eax
    M33fromEuler RTmatrix, eax, [RTmatrix],eax
    ObjSetScale discoTileScale1
    CCALL   _DISCOB_render, gDisco, RTmatrix
;outer disco ball
    fld     dword[RTM_time]
    fmul    dword[discoRotSpeed2]
    fstp    dword[RTmatrix]
    xor     eax,eax
    M33fromEuler RTmatrix, eax, [RTmatrix],eax
    ObjSetScale discoTileScale2
    CCALL   _DISCOB_render, gDisco2, RTmatrix

    CCALL   _DISCOB_renderVertBeam
    CCALL   _renderLasers
.exit:
DECLEND
;==============================================================================
