uniform sampler2D sampler0;
uniform sampler2D sampler1;
uniform float delta;

varying vec2 texcoord;
varying vec4 color;

void main(void)
{
	vec4 s0 = texture2D(sampler0, texcoord);
	vec4 s1 = texture2D(sampler1, texcoord);

	vec4 c = (1.0 - delta) * s0 + delta * s1;
	c.r *= color.r;
	c.g *= color.g;
	c.b *= color.b;
	c.a *= color.a;

	gl_FragColor = c;
}