using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Drawing.Design;
using System.Text;
using System.Windows.Forms;

namespace StarifficEditor
{
    public class MeshDesignEditor : UITypeEditor
    {
        public override UITypeEditorEditStyle GetEditStyle(ITypeDescriptorContext context)
        {
            return UITypeEditorEditStyle.Modal;
        }

        public override object EditValue(ITypeDescriptorContext context, IServiceProvider provider, object value)
        {
            MeshSelectForm form = new MeshSelectForm(value as String);

            if (form.ShowDialog() != DialogResult.OK)
                return value;
            return form.Mesh;
        }
    }
}
